/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.mail;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.mail.Authenticator;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.aopalliance.aop.Advice;
import org.springframework.expression.Expression;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.FunctionExpression;
import org.springframework.integration.dsl.support.PropertiesBuilder;
import org.springframework.integration.mail.ImapIdleChannelAdapter;
import org.springframework.integration.mail.ImapMailReceiver;
import org.springframework.integration.mail.SearchTermStrategy;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.transaction.TransactionSynchronizationFactory;
import org.springframework.util.Assert;

public class ImapIdleChannelAdapterSpec
extends MessageProducerSpec<ImapIdleChannelAdapterSpec, ImapIdleChannelAdapter>
implements ComponentsRegistration {
    private final ImapMailReceiver receiver;
    protected final boolean externalReceiver;
    private boolean sessionProvided;

    ImapIdleChannelAdapterSpec(ImapMailReceiver receiver) {
        this(receiver, false);
    }

    ImapIdleChannelAdapterSpec(ImapMailReceiver receiver, boolean externalReceiver) {
        super(new ImapIdleChannelAdapter(receiver));
        this.receiver = receiver;
        this.externalReceiver = externalReceiver;
    }

    public ImapIdleChannelAdapterSpec selectorExpression(String selectorExpression) {
        return this.selectorExpression(PARSER.parseExpression(selectorExpression));
    }

    public ImapIdleChannelAdapterSpec selectorExpression(Expression selectorExpression) {
        this.assertReceiver();
        this.receiver.setSelectorExpression(selectorExpression);
        return this;
    }

    private void assertReceiver() {
        Assert.state((!this.externalReceiver ? 1 : 0) != 0, (String)("An external 'receiver' [" + this.receiver + "] can't be modified."));
    }

    public ImapIdleChannelAdapterSpec selector(Function<MimeMessage, Boolean> selectorFunction) {
        return this.selectorExpression(new FunctionExpression<MimeMessage>(selectorFunction));
    }

    public ImapIdleChannelAdapterSpec session(Session session) {
        this.assertReceiver();
        this.receiver.setSession(session);
        this.sessionProvided = true;
        return this;
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(Properties javaMailProperties) {
        this.assertReceiver();
        this.assertSession();
        this.receiver.setJavaMailProperties(javaMailProperties);
        return this;
    }

    private void assertSession() {
        Assert.state((!this.sessionProvided ? 1 : 0) != 0, (String)"Neither 'javaMailProperties' nor 'javaMailAuthenticator' references are allowed when a 'session' reference has been provided.");
    }

    public ImapIdleChannelAdapterSpec javaMailProperties(Consumer<PropertiesBuilder> configurer) {
        PropertiesBuilder properties = new PropertiesBuilder();
        configurer.accept(properties);
        return this.javaMailProperties(properties.get());
    }

    public ImapIdleChannelAdapterSpec javaMailAuthenticator(Authenticator javaMailAuthenticator) {
        this.assertReceiver();
        this.assertSession();
        this.receiver.setJavaMailAuthenticator(javaMailAuthenticator);
        return this;
    }

    public ImapIdleChannelAdapterSpec maxFetchSize(int maxFetchSize) {
        this.assertReceiver();
        this.receiver.setMaxFetchSize(maxFetchSize);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldDeleteMessages(boolean shouldDeleteMessages) {
        this.assertReceiver();
        this.receiver.setShouldDeleteMessages(shouldDeleteMessages);
        return this;
    }

    public ImapIdleChannelAdapterSpec searchTermStrategy(SearchTermStrategy searchTermStrategy) {
        this.assertReceiver();
        this.receiver.setSearchTermStrategy(searchTermStrategy);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldMarkMessagesAsRead(boolean shouldMarkMessagesAsRead) {
        this.assertReceiver();
        this.receiver.setShouldMarkMessagesAsRead(Boolean.valueOf(shouldMarkMessagesAsRead));
        return this;
    }

    public ImapIdleChannelAdapterSpec userFlag(String userFlag) {
        this.assertReceiver();
        this.receiver.setUserFlag(userFlag);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec headerMapper(HeaderMapper<MimeMessage> headerMapper) {
        this.assertReceiver();
        this.receiver.setHeaderMapper(headerMapper);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec embeddedPartsAsBytes(boolean embeddedPartsAsBytes) {
        this.assertReceiver();
        this.receiver.setEmbeddedPartsAsBytes(embeddedPartsAsBytes);
        return (ImapIdleChannelAdapterSpec)this._this();
    }

    public ImapIdleChannelAdapterSpec transactionSynchronizationFactory(TransactionSynchronizationFactory transactionSynchronizationFactory) {
        ((ImapIdleChannelAdapter)this.target).setTransactionSynchronizationFactory(transactionSynchronizationFactory);
        return this;
    }

    public ImapIdleChannelAdapterSpec adviceChain(Advice ... adviceChain) {
        ((ImapIdleChannelAdapter)this.target).setAdviceChain(Arrays.asList(adviceChain));
        return this;
    }

    public ImapIdleChannelAdapterSpec sendingTaskExecutor(Executor sendingTaskExecutor) {
        ((ImapIdleChannelAdapter)this.target).setSendingTaskExecutor(sendingTaskExecutor);
        return this;
    }

    public ImapIdleChannelAdapterSpec shouldReconnectAutomatically(boolean shouldReconnectAutomatically) {
        ((ImapIdleChannelAdapter)this.target).setShouldReconnectAutomatically(shouldReconnectAutomatically);
        return this;
    }

    @Override
    public Collection<Object> getComponentsToRegister() {
        return Collections.singletonList(this.receiver);
    }
}

