/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl.ftp;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.net.ftp.FTPFile;
import org.springframework.integration.dsl.file.RemoteFileInboundChannelAdapterSpec;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.ftp.filters.FtpRegexPatternFileListFilter;
import org.springframework.integration.ftp.filters.FtpSimplePatternFileListFilter;
import org.springframework.integration.ftp.inbound.FtpInboundFileSynchronizer;
import org.springframework.integration.ftp.inbound.FtpInboundFileSynchronizingMessageSource;

public class FtpInboundChannelAdapterSpec
extends RemoteFileInboundChannelAdapterSpec<FTPFile, FtpInboundChannelAdapterSpec, FtpInboundFileSynchronizingMessageSource> {
    FtpInboundChannelAdapterSpec(SessionFactory<FTPFile> sessionFactory, Comparator<File> comparator) {
        super(new FtpInboundFileSynchronizer(sessionFactory));
        this.target = new FtpInboundFileSynchronizingMessageSource(this.synchronizer, comparator);
    }

    @Override
    public FtpInboundChannelAdapterSpec patternFilter(String pattern) {
        return (FtpInboundChannelAdapterSpec)this.filter(new FtpSimplePatternFileListFilter(pattern));
    }

    @Override
    public FtpInboundChannelAdapterSpec regexFilter(String regex) {
        return (FtpInboundChannelAdapterSpec)this.filter(new FtpRegexPatternFileListFilter(regex));
    }
}

