/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import org.springframework.beans.DirectFieldAccessor;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.dsl.Channels;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessageProducers;
import org.springframework.integration.dsl.MessageSources;
import org.springframework.integration.dsl.MessagingGateways;
import org.springframework.integration.dsl.SourcePollingChannelAdapterSpec;
import org.springframework.integration.dsl.channel.MessageChannelSpec;
import org.springframework.integration.dsl.core.ComponentsRegistration;
import org.springframework.integration.dsl.core.MessageProducerSpec;
import org.springframework.integration.dsl.core.MessageSourceSpec;
import org.springframework.integration.dsl.core.MessagingGatewaySpec;
import org.springframework.integration.dsl.support.Consumer;
import org.springframework.integration.dsl.support.FixedSubscriberChannelPrototype;
import org.springframework.integration.dsl.support.Function;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.endpoint.MethodInvokingMessageSource;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public final class IntegrationFlows {
    public static IntegrationFlowBuilder from(String messageChannelName) {
        return IntegrationFlows.from(new MessageChannelReference(messageChannelName));
    }

    public static IntegrationFlowBuilder from(String messageChannelName, boolean fixedSubscriber) {
        return fixedSubscriber ? IntegrationFlows.from(new FixedSubscriberChannelPrototype(messageChannelName)) : IntegrationFlows.from(messageChannelName);
    }

    public static IntegrationFlowBuilder from(ChannelsFunction channels) {
        Assert.notNull((Object)channels);
        return IntegrationFlows.from((MessageChannelSpec)channels.apply(new Channels()));
    }

    public static IntegrationFlowBuilder from(MessageChannelSpec<?, ?> messageChannelSpec) {
        Assert.notNull(messageChannelSpec);
        return IntegrationFlows.from((MessageChannel)messageChannelSpec.get());
    }

    public static IntegrationFlowBuilder from(MessageChannel messageChannel) {
        return (IntegrationFlowBuilder)new IntegrationFlowBuilder().channel(messageChannel);
    }

    public static IntegrationFlowBuilder from(MessageSourcesFunction sources) {
        return IntegrationFlows.from(sources, (Consumer<SourcePollingChannelAdapterSpec>)null);
    }

    public static IntegrationFlowBuilder from(MessageSourcesFunction sources, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        Assert.notNull((Object)sources);
        return IntegrationFlows.from((MessageSourceSpec)sources.apply(new MessageSources()), endpointConfigurer);
    }

    public static IntegrationFlowBuilder from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec) {
        return IntegrationFlows.from(messageSourceSpec, (Consumer<SourcePollingChannelAdapterSpec>)null);
    }

    public static IntegrationFlowBuilder from(MessageSourceSpec<?, ? extends MessageSource<?>> messageSourceSpec, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        Assert.notNull(messageSourceSpec);
        return IntegrationFlows.from((MessageSource)messageSourceSpec.get(), endpointConfigurer, IntegrationFlows.registerComponents(messageSourceSpec));
    }

    public static IntegrationFlowBuilder from(Object service, String methodName) {
        return IntegrationFlows.from(service, methodName, null);
    }

    public static IntegrationFlowBuilder from(Object service, String methodName, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        Assert.notNull((Object)service);
        Assert.hasText((String)methodName);
        MethodInvokingMessageSource messageSource = new MethodInvokingMessageSource();
        messageSource.setObject(service);
        messageSource.setMethodName(methodName);
        return IntegrationFlows.from(messageSource, endpointConfigurer);
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource) {
        return IntegrationFlows.from(messageSource, (Consumer<SourcePollingChannelAdapterSpec>)null);
    }

    public static IntegrationFlowBuilder from(MessageSource<?> messageSource, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer) {
        return IntegrationFlows.from(messageSource, endpointConfigurer, null);
    }

    private static IntegrationFlowBuilder from(MessageSource<?> messageSource, Consumer<SourcePollingChannelAdapterSpec> endpointConfigurer, IntegrationFlowBuilder integrationFlowBuilder) {
        SourcePollingChannelAdapterSpec spec = new SourcePollingChannelAdapterSpec(messageSource);
        if (endpointConfigurer != null) {
            endpointConfigurer.accept(spec);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = new IntegrationFlowBuilder();
        }
        return (IntegrationFlowBuilder)((IntegrationFlowBuilder)integrationFlowBuilder.addComponent(spec)).currentComponent(spec);
    }

    public static IntegrationFlowBuilder from(MessageProducersFunction producers) {
        return IntegrationFlows.from((MessageProducerSpec)producers.apply(new MessageProducers()));
    }

    public static IntegrationFlowBuilder from(MessageProducerSpec<?, ?> messageProducerSpec) {
        return IntegrationFlows.from((MessageProducerSupport)messageProducerSpec.get(), IntegrationFlows.registerComponents(messageProducerSpec));
    }

    public static IntegrationFlowBuilder from(MessageProducerSupport messageProducer) {
        return IntegrationFlows.from(messageProducer, (IntegrationFlowBuilder)null);
    }

    private static IntegrationFlowBuilder from(MessageProducerSupport messageProducer, IntegrationFlowBuilder integrationFlowBuilder) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)messageProducer);
        MessageChannel outputChannel = (MessageChannel)dfa.getPropertyValue("outputChannel");
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            messageProducer.setOutputChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlows.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(messageProducer);
    }

    public static IntegrationFlowBuilder from(MessagingGatewaysFunction gateways) {
        return IntegrationFlows.from((MessagingGatewaySpec)gateways.apply(new MessagingGateways()));
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySpec<?, ?> inboundGatewaySpec) {
        return IntegrationFlows.from((MessagingGatewaySupport)inboundGatewaySpec.get(), IntegrationFlows.registerComponents(inboundGatewaySpec));
    }

    public static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway) {
        return IntegrationFlows.from(inboundGateway, (IntegrationFlowBuilder)null);
    }

    private static IntegrationFlowBuilder from(MessagingGatewaySupport inboundGateway, IntegrationFlowBuilder integrationFlowBuilder) {
        DirectFieldAccessor dfa = new DirectFieldAccessor((Object)inboundGateway);
        MessageChannel outputChannel = (MessageChannel)dfa.getPropertyValue("requestChannel");
        if (outputChannel == null) {
            outputChannel = new DirectChannel();
            inboundGateway.setRequestChannel(outputChannel);
        }
        if (integrationFlowBuilder == null) {
            integrationFlowBuilder = IntegrationFlows.from(outputChannel);
        } else {
            integrationFlowBuilder.channel(outputChannel);
        }
        return (IntegrationFlowBuilder)integrationFlowBuilder.addComponent(inboundGateway);
    }

    private static IntegrationFlowBuilder registerComponents(Object spec) {
        if (spec instanceof ComponentsRegistration) {
            return (IntegrationFlowBuilder)new IntegrationFlowBuilder().addComponents(((ComponentsRegistration)spec).getComponentsToRegister());
        }
        return null;
    }

    private IntegrationFlows() {
    }

    public static interface MessagingGatewaysFunction
    extends Function<MessagingGateways, MessagingGatewaySpec<?, ?>> {
    }

    public static interface MessageProducersFunction
    extends Function<MessageProducers, MessageProducerSpec<?, ?>> {
    }

    public static interface MessageSourcesFunction
    extends Function<MessageSources, MessageSourceSpec<?, ?>> {
    }

    public static interface ChannelsFunction
    extends Function<Channels, MessageChannelSpec<?, ?>> {
    }
}

