/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.dsl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.dsl.support.MessageChannelReference;
import org.springframework.integration.dsl.support.tuple.Tuple2;
import org.springframework.integration.dsl.support.tuple.Tuples;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.router.RecipientListRouter;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.util.StringUtils;

class DslRecipientListRouter
extends RecipientListRouter {
    private final List<Tuple2<?, ?>> recipients = new ArrayList();

    DslRecipientListRouter() {
    }

    void add(String channelName, String expression) {
        this.recipients.add(Tuples.of(channelName, expression));
    }

    void add(String channelName, MessageSelector selector) {
        this.recipients.add(Tuples.of(channelName, selector));
    }

    void add(MessageChannel channel, String expression) {
        this.recipients.add(Tuples.of(channel, expression));
    }

    void add(MessageChannel channel, MessageSelector selector) {
        this.recipients.add(Tuples.of(channel, selector));
    }

    public void onInit() throws Exception {
        ArrayList<RecipientListRouter.Recipient> recipients = new ArrayList<RecipientListRouter.Recipient>(this.recipients.size());
        for (Tuple2<?, ?> recipient : this.recipients) {
            if (recipient.getT1() instanceof String) {
                recipients.add(new DslRecipient(new MessageChannelReference((String)recipient.getT1()), this.populateRecipientSelector(recipient.getT2())));
                continue;
            }
            recipients.add(new RecipientListRouter.Recipient((MessageChannel)recipient.getT1(), this.populateRecipientSelector(recipient.getT2())));
        }
        this.setRecipients(recipients);
        this.recipients.clear();
        super.onInit();
    }

    private MessageSelector populateRecipientSelector(Object recipientSelector) {
        if (recipientSelector instanceof String) {
            String expression = (String)recipientSelector;
            if (StringUtils.hasText((String)expression)) {
                ExpressionEvaluatingSelector selector = new ExpressionEvaluatingSelector(expression);
                selector.setBeanFactory(this.getBeanFactory());
                return selector;
            }
        } else {
            return (MessageSelector)recipientSelector;
        }
        return null;
    }

    class DslRecipient
    extends RecipientListRouter.Recipient {
        private volatile MessageChannel channel;

        DslRecipient(MessageChannelReference channel, MessageSelector selector) {
            super((MessageChannel)channel, selector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageChannel getChannel() {
            if (this.channel == null) {
                DslRecipient dslRecipient = this;
                synchronized (dslRecipient) {
                    if (this.channel == null) {
                        this.channel = this.resolveChannelName((MessageChannelReference)super.getChannel());
                    }
                }
            }
            return this.channel;
        }

        private MessageChannel resolveChannelName(MessageChannelReference channelReference) {
            String channelName = channelReference.getName();
            try {
                return (MessageChannel)DslRecipientListRouter.this.getBeanFactory().getBean(channelName, MessageChannel.class);
            }
            catch (BeansException e) {
                throw new DestinationResolutionException("Failed to look up MessageChannel with name '" + channelName + "' in the BeanFactory.");
            }
        }
    }
}

