/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.oxm;

import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.transform.Source;
import org.springframework.batch.item.xml.EventReaderDeserializer;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.xml.transform.StaxSource;

public class UnmarshallingEventReaderDeserializer
implements EventReaderDeserializer {
    private Unmarshaller unmarshaller;

    public UnmarshallingEventReaderDeserializer(Unmarshaller unmarshaller) {
        Assert.notNull((Object)unmarshaller);
        this.unmarshaller = unmarshaller;
    }

    public Object deserializeFragment(XMLEventReader eventReader) {
        Object item = null;
        try {
            item = this.unmarshaller.unmarshal((Source)new StaxSource(eventReader));
        }
        catch (IOException e) {
            throw new DataAccessResourceFailureException("IO error during unmarshalling", (Throwable)e);
        }
        return item;
    }
}

