/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.alpn.agent;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Map;
import org.mortbay.jetty.alpn.agent.Util;

final class ReplacingClassFileTransformer
implements ClassFileTransformer {
    private final Map<String, byte[]> classes;

    ReplacingClassFileTransformer(Map<String, byte[]> classes) {
        this.classes = classes;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        byte[] content = this.classes.get(className);
        if (content == null || Arrays.equals(content, classfileBuffer)) {
            return null;
        }
        Util.log("Replacing: " + className);
        return (byte[])content.clone();
    }
}

