/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.sax;

import com.kohlschutter.boilerpipe.BoilerpipeExtractor;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.Image;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.org.cyberneko.html.HTMLConfiguration;
import com.kohlschutter.boilerpipe.sax.BoilerpipeSAXInput;
import com.kohlschutter.boilerpipe.sax.HTMLDocument;
import com.kohlschutter.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class ImageExtractor {
    public static final ImageExtractor INSTANCE = new ImageExtractor();
    private static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        @Override
        void beforeStart(Implementation instance, String localName) {
            instance.inIgnorableElement++;
        }

        @Override
        void afterEnd(Implementation instance, String localName) {
            instance.inIgnorableElement--;
        }
    };
    private static Map<String, TagAction> TAG_ACTIONS = new HashMap<String, TagAction>();

    public static ImageExtractor getInstance() {
        return INSTANCE;
    }

    private ImageExtractor() {
    }

    public List<Image> process(TextDocument doc, String origHTML) throws BoilerpipeProcessingException {
        return this.process(doc, new InputSource(new StringReader(origHTML)));
    }

    public List<Image> process(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
        Implementation implementation = new Implementation();
        implementation.process(doc, is);
        return implementation.linksHighlight;
    }

    public List<Image> process(URL url, BoilerpipeExtractor extractor) throws IOException, BoilerpipeProcessingException, SAXException {
        HTMLDocument htmlDoc = HTMLFetcher.fetch(url);
        TextDocument doc = new BoilerpipeSAXInput(htmlDoc.toInputSource()).getTextDocument();
        extractor.process(doc);
        InputSource is = htmlDoc.toInputSource();
        return this.process(doc, is);
    }

    static {
        TAG_ACTIONS.put("STYLE", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("SCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OPTION", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("NOSCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("EMBED", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("APPLET", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("LINK", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("HEAD", TA_IGNORABLE_ELEMENT);
    }

    private static abstract class TagAction {
        private TagAction() {
        }

        void beforeStart(Implementation instance, String localName) {
        }

        void afterStart(Implementation instance, String localName) {
        }

        void beforeEnd(Implementation instance, String localName) {
        }

        void afterEnd(Implementation instance, String localName) {
        }
    }

    private final class Implementation
    extends AbstractSAXParser
    implements ContentHandler {
        List<Image> linksHighlight;
        private List<Image> linksBuffer;
        private int inIgnorableElement;
        private int characterElementIdx;
        private final BitSet contentBitSet;
        private boolean inHighlight;

        Implementation() {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.linksHighlight = new ArrayList<Image>();
            this.linksBuffer = new ArrayList<Image>();
            this.inIgnorableElement = 0;
            this.characterElementIdx = 0;
            this.contentBitSet = new BitSet();
            this.inHighlight = false;
            this.setContentHandler(this);
        }

        void process(TextDocument doc, InputSource is) throws BoilerpipeProcessingException {
            for (TextBlock block : doc.getTextBlocks()) {
                BitSet bs;
                if (!block.isContent() || (bs = block.getContainedTextElements()) == null) continue;
                this.contentBitSet.or(bs);
            }
            try {
                this.parse(is);
            }
            catch (SAXException e) {
                throw new BoilerpipeProcessingException(e);
            }
            catch (IOException e) {
                throw new BoilerpipeProcessingException(e);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
            if (ta != null) {
                ta.beforeStart(this, localName);
            }
            try {
                String src;
                if (this.inIgnorableElement == 0 && this.inHighlight && "IMG".equalsIgnoreCase(localName) && (src = atts.getValue("src")) != null && src.length() > 0) {
                    this.linksBuffer.add(new Image(src, atts.getValue("width"), atts.getValue("height"), atts.getValue("alt")));
                }
            }
            finally {
                if (ta != null) {
                    ta.afterStart(this, localName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            TagAction ta = (TagAction)TAG_ACTIONS.get(localName);
            if (ta != null) {
                ta.beforeEnd(this, localName);
            }
            try {
                if (this.inIgnorableElement == 0) {
                    // empty if block
                }
            }
            finally {
                if (ta != null) {
                    ta.afterEnd(this, localName);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            ++this.characterElementIdx;
            if (this.inIgnorableElement == 0) {
                boolean highlight = this.contentBitSet.get(this.characterElementIdx);
                if (!highlight) {
                    if (length == 0) {
                        return;
                    }
                    boolean justWhitespace = true;
                    for (int i = start; i < start + length; ++i) {
                        if (Character.isWhitespace(ch[i])) continue;
                        justWhitespace = false;
                        break;
                    }
                    if (justWhitespace) {
                        return;
                    }
                }
                this.inHighlight = highlight;
                if (this.inHighlight) {
                    this.linksHighlight.addAll(this.linksBuffer);
                    this.linksBuffer.clear();
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

