/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.simple;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.conditions.TextBlockCondition;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public class SurroundingToContentFilter
implements BoilerpipeFilter {
    public static final SurroundingToContentFilter INSTANCE_TEXT = new SurroundingToContentFilter(new TextBlockCondition(){

        @Override
        public boolean meetsCondition(TextBlock tb) {
            return tb.getLinkDensity() == 0.0f && tb.getNumWords() > 6;
        }
    });
    private final TextBlockCondition cond;

    public SurroundingToContentFilter(TextBlockCondition cond) {
        this.cond = cond;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> tbs = doc.getTextBlocks();
        if (tbs.size() < 3) {
            return false;
        }
        TextBlock a = tbs.get(0);
        TextBlock b = tbs.get(1);
        boolean hasChanges = false;
        ListIterator<TextBlock> it = tbs.listIterator(2);
        while (it.hasNext()) {
            TextBlock c = (TextBlock)it.next();
            if (!b.isContent() && a.isContent() && c.isContent() && this.cond.meetsCondition(b)) {
                b.setIsContent(true);
                hasChanges = true;
            }
            a = c;
            if (!it.hasNext()) break;
            b = (TextBlock)it.next();
        }
        return hasChanges;
    }
}

