/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.simple;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;

public final class MinWordsFilter
implements BoilerpipeFilter {
    private final int minWords;

    public MinWordsFilter(int minWords) {
        this.minWords = minWords;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || tb.getNumWords() >= this.minWords) continue;
            tb.setIsContent(false);
            changes = true;
        }
        return changes;
    }
}

