/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.simple;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.Iterator;
import java.util.List;

public final class BoilerplateBlockFilter
implements BoilerpipeFilter {
    public static final BoilerplateBlockFilter INSTANCE = new BoilerplateBlockFilter(null);
    public static final BoilerplateBlockFilter INSTANCE_KEEP_TITLE = new BoilerplateBlockFilter("de.l3s.boilerpipe/TITLE");
    private final String labelToKeep;

    public static BoilerplateBlockFilter getInstance() {
        return INSTANCE;
    }

    public BoilerplateBlockFilter(String labelToKeep) {
        this.labelToKeep = labelToKeep;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean hasChanges = false;
        Iterator<TextBlock> it = textBlocks.iterator();
        while (it.hasNext()) {
            TextBlock tb = it.next();
            if (tb.isContent() || this.labelToKeep != null && tb.hasLabel("de.l3s.boilerpipe/TITLE")) continue;
            it.remove();
            hasChanges = true;
        }
        return hasChanges;
    }
}

