/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public final class TrailingHeadlineToBoilerplateFilter
implements BoilerpipeFilter {
    public static final TrailingHeadlineToBoilerplateFilter INSTANCE = new TrailingHeadlineToBoilerplateFilter();

    public static TrailingHeadlineToBoilerplateFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        List<TextBlock> list = doc.getTextBlocks();
        ListIterator<TextBlock> it = list.listIterator(list.size());
        while (it.hasPrevious()) {
            TextBlock tb = it.previous();
            if (!tb.isContent()) continue;
            if (!tb.hasLabel("de.l3s.boilerpipe/HEADING")) break;
            tb.setIsContent(false);
            changes = true;
        }
        return changes;
    }
}

