/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;

public final class ListAtEndFilter
implements BoilerpipeFilter {
    public static final ListAtEndFilter INSTANCE = new ListAtEndFilter();

    private ListAtEndFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int tagLevel = Integer.MAX_VALUE;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() && tb.hasLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT")) {
                tagLevel = tb.getTagLevel();
                continue;
            }
            if (tb.getTagLevel() > tagLevel && tb.hasLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT") && tb.hasLabel("de.l3s.boilerpipe/LI") && tb.getLinkDensity() == 0.0f) {
                tb.setIsContent(true);
                changes = true;
                continue;
            }
            tagLevel = Integer.MAX_VALUE;
        }
        return changes;
    }
}

