/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;

public final class LargeBlockSameTagLevelToContentFilter
implements BoilerpipeFilter {
    public static final LargeBlockSameTagLevelToContentFilter INSTANCE = new LargeBlockSameTagLevelToContentFilter();

    private LargeBlockSameTagLevelToContentFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int tagLevel = -1;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || !tb.hasLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT")) continue;
            tagLevel = tb.getTagLevel();
            break;
        }
        if (tagLevel == -1) {
            return false;
        }
        for (TextBlock tb : doc.getTextBlocks()) {
            if (tb.isContent() || tb.getNumWords() < 100 || tb.getTagLevel() != tagLevel) continue;
            tb.setIsContent(true);
            changes = true;
        }
        return changes;
    }
}

