/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class LabelFusion
implements BoilerpipeFilter {
    public static final LabelFusion INSTANCE = new LabelFusion();

    private LabelFusion() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        boolean changes = false;
        TextBlock prevBlock = textBlocks.get(0);
        int offset = 1;
        ListIterator<TextBlock> it = textBlocks.listIterator(offset);
        while (it.hasNext()) {
            TextBlock block = (TextBlock)it.next();
            if (this.equalLabels(prevBlock.getLabels(), block.getLabels())) {
                prevBlock.mergeNext(block);
                it.remove();
                changes = true;
                continue;
            }
            prevBlock = block;
        }
        return changes;
    }

    private boolean equalLabels(Set<String> labels, Set<String> labels2) {
        if (labels == null || labels2 == null) {
            return false;
        }
        return this.markupLabelsOnly(labels).equals(this.markupLabelsOnly(labels2));
    }

    private Set<String> markupLabelsOnly(Set<String> set1) {
        HashSet<String> set = new HashSet<String>(set1);
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String label = (String)it.next();
            if (label.startsWith("<")) continue;
            it.remove();
        }
        return set;
    }
}

