/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;

public final class ExpandTitleToContentFilter
implements BoilerpipeFilter {
    public static final ExpandTitleToContentFilter INSTANCE = new ExpandTitleToContentFilter();

    public static ExpandTitleToContentFilter getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        int i = 0;
        int title = -1;
        int contentStart = -1;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (contentStart == -1 && tb.hasLabel("de.l3s.boilerpipe/TITLE")) {
                title = i;
                contentStart = -1;
            }
            if (contentStart == -1 && tb.isContent()) {
                contentStart = i;
            }
            ++i;
        }
        if (contentStart <= title || title == -1) {
            return false;
        }
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks().subList(title, contentStart)) {
            if (!tb.hasLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT")) continue;
            changes = tb.setIsContent(true) | changes;
        }
        return changes;
    }
}

