/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.heuristics;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public final class ContentFusion
implements BoilerpipeFilter {
    public static final ContentFusion INSTANCE = new ContentFusion();

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        TextBlock prevBlock = textBlocks.get(0);
        boolean changes = false;
        do {
            changes = false;
            ListIterator<TextBlock> it = textBlocks.listIterator(1);
            while (it.hasNext()) {
                TextBlock block = it.next();
                if (prevBlock.isContent() && (double)block.getLinkDensity() < 0.56 && !block.hasLabel("de.l3s.boilerpipe/STRICTLY_NOT_CONTENT")) {
                    prevBlock.mergeNext(block);
                    it.remove();
                    changes = true;
                    continue;
                }
                prevBlock = block;
            }
        } while (changes);
        return true;
    }
}

