/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.english;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public class NumWordsRulesClassifier
implements BoilerpipeFilter {
    public static final NumWordsRulesClassifier INSTANCE = new NumWordsRulesClassifier();

    public static NumWordsRulesClassifier getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean hasChanges = false;
        ListIterator<TextBlock> it = textBlocks.listIterator();
        if (!it.hasNext()) {
            return false;
        }
        TextBlock prevBlock = TextBlock.EMPTY_START;
        TextBlock currentBlock = it.next();
        TextBlock nextBlock = it.hasNext() ? it.next() : TextBlock.EMPTY_START;
        hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        if (nextBlock != TextBlock.EMPTY_START) {
            while (it.hasNext()) {
                prevBlock = currentBlock;
                currentBlock = nextBlock;
                nextBlock = it.next();
                hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
            }
            prevBlock = currentBlock;
            currentBlock = nextBlock;
            nextBlock = TextBlock.EMPTY_START;
            hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        }
        return hasChanges;
    }

    protected boolean classify(TextBlock prev, TextBlock curr, TextBlock next) {
        boolean isContent = (double)curr.getLinkDensity() <= 0.333333 ? ((double)prev.getLinkDensity() <= 0.555556 ? (curr.getNumWords() <= 16 ? (next.getNumWords() <= 15 ? prev.getNumWords() > 4 : true) : true) : (curr.getNumWords() <= 40 ? next.getNumWords() > 17 : true)) : false;
        return curr.setIsContent(isContent);
    }
}

