/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.english;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.filters.english.HeuristicFilterBase;

public final class MinFulltextWordsFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final MinFulltextWordsFilter DEFAULT_INSTANCE = new MinFulltextWordsFilter(30);
    private final int minWords;

    public static MinFulltextWordsFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public MinFulltextWordsFilter(int minWords) {
        this.minWords = minWords;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            if (!tb.isContent() || MinFulltextWordsFilter.getNumFullTextWords(tb) >= this.minWords) continue;
            tb.setIsContent(false);
            changes = true;
        }
        return changes;
    }
}

