/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.english;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.filters.english.HeuristicFilterBase;
import java.util.List;

public final class KeepLargestFulltextBlockFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final KeepLargestFulltextBlockFilter INSTANCE = new KeepLargestFulltextBlockFilter();

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        if (textBlocks.size() < 2) {
            return false;
        }
        int max = -1;
        TextBlock largestBlock = null;
        for (TextBlock tb : textBlocks) {
            int numWords;
            if (!tb.isContent() || (numWords = KeepLargestFulltextBlockFilter.getNumFullTextWords(tb)) <= max) continue;
            largestBlock = tb;
            max = numWords;
        }
        if (largestBlock == null) {
            return false;
        }
        for (TextBlock tb : textBlocks) {
            if (tb == largestBlock) {
                tb.setIsContent(true);
                continue;
            }
            tb.setIsContent(false);
            tb.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        return true;
    }
}

