/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.english;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.filters.english.HeuristicFilterBase;
import java.util.List;
import java.util.ListIterator;

public final class IgnoreBlocksAfterContentFromEndFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final IgnoreBlocksAfterContentFromEndFilter INSTANCE = new IgnoreBlocksAfterContentFromEndFilter();

    private IgnoreBlocksAfterContentFromEndFilter() {
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int words = 0;
        List<TextBlock> blocks = doc.getTextBlocks();
        if (!blocks.isEmpty()) {
            ListIterator<TextBlock> it = blocks.listIterator(blocks.size());
            while (it.hasPrevious()) {
                TextBlock tb = it.previous();
                if (tb.hasLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT")) {
                    tb.addLabel("de.l3s.boilerpipe/STRICTLY_NOT_CONTENT");
                    tb.removeLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
                    tb.setIsContent(false);
                    changes = true;
                    continue;
                }
                if (!tb.isContent() || (words += tb.getNumWords()) <= 200) continue;
                break;
            }
        }
        return changes;
    }
}

