/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.filters.english;

import com.kohlschutter.boilerpipe.BoilerpipeFilter;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.filters.english.HeuristicFilterBase;

public final class IgnoreBlocksAfterContentFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final IgnoreBlocksAfterContentFilter DEFAULT_INSTANCE = new IgnoreBlocksAfterContentFilter(60);
    public static final IgnoreBlocksAfterContentFilter INSTANCE_200 = new IgnoreBlocksAfterContentFilter(200);
    private final int minNumWords;

    public static IgnoreBlocksAfterContentFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public IgnoreBlocksAfterContentFilter(int minNumWords) {
        this.minNumWords = minNumWords;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        int numWords = 0;
        boolean foundEndOfText = false;
        for (TextBlock block : doc.getTextBlocks()) {
            boolean endOfText = block.hasLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
            if (block.isContent()) {
                numWords += IgnoreBlocksAfterContentFilter.getNumFullTextWords(block);
            }
            if (endOfText && numWords >= this.minNumWords) {
                foundEndOfText = true;
            }
            if (!foundEndOfText) continue;
            changes = true;
            block.setIsContent(false);
        }
        return changes;
    }
}

