/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.extractors;

import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.extractors.ExtractorBase;
import com.kohlschutter.boilerpipe.filters.english.NumWordsRulesClassifier;
import com.kohlschutter.boilerpipe.filters.heuristics.BlockProximityFusion;
import com.kohlschutter.boilerpipe.filters.heuristics.KeepLargestBlockFilter;

public final class LargestContentExtractor
extends ExtractorBase {
    public static final LargestContentExtractor INSTANCE = new LargestContentExtractor();

    private LargestContentExtractor() {
    }

    public static LargestContentExtractor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        return NumWordsRulesClassifier.INSTANCE.process(doc) | BlockProximityFusion.MAX_DISTANCE_1.process(doc) | KeepLargestBlockFilter.INSTANCE.process(doc);
    }
}

