/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.extractors;

import com.kohlschutter.boilerpipe.BoilerpipeExtractor;
import com.kohlschutter.boilerpipe.BoilerpipeProcessingException;
import com.kohlschutter.boilerpipe.document.TextDocument;
import com.kohlschutter.boilerpipe.sax.BoilerpipeSAXInput;
import com.kohlschutter.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ExtractorBase
implements BoilerpipeExtractor {
    @Override
    public String getText(String html) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(new InputSource(new StringReader(html))).getTextDocument());
        }
        catch (SAXException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    @Override
    public String getText(InputSource is) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(is).getTextDocument());
        }
        catch (SAXException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    public String getText(URL url) throws BoilerpipeProcessingException {
        try {
            return this.getText(HTMLFetcher.fetch(url).toInputSource());
        }
        catch (IOException e) {
            throw new BoilerpipeProcessingException(e);
        }
    }

    @Override
    public String getText(Reader r) throws BoilerpipeProcessingException {
        return this.getText(new InputSource(r));
    }

    @Override
    public String getText(TextDocument doc) throws BoilerpipeProcessingException {
        this.process(doc);
        return doc.getContent();
    }
}

