/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.document;

import com.kohlschutter.boilerpipe.document.TextBlock;
import com.kohlschutter.boilerpipe.document.TextDocument;

public final class TextDocumentStatistics {
    private int numWords = 0;
    private int numBlocks = 0;

    public TextDocumentStatistics(TextDocument doc, boolean contentOnly) {
        for (TextBlock tb : doc.getTextBlocks()) {
            if (contentOnly && !tb.isContent()) continue;
            this.numWords += tb.getNumWords();
            ++this.numBlocks;
        }
    }

    public float avgNumWords() {
        return (float)this.numWords / (float)this.numBlocks;
    }

    public int getNumWords() {
        return this.numWords;
    }
}

