/*
 * Decompiled with CFR 0.152.
 */
package com.kohlschutter.boilerpipe.document;

public class Image
implements Comparable<Image> {
    private final String src;
    private final String width;
    private final String height;
    private final String alt;
    private final int area;

    public Image(String src, String width, String height, String alt) {
        this.src = src;
        if (src == null) {
            throw new NullPointerException("src attribute must not be null");
        }
        this.width = Image.nullTrim(width);
        this.height = Image.nullTrim(height);
        this.alt = Image.nullTrim(alt);
        if (width != null && height != null) {
            int a;
            try {
                a = Integer.parseInt(width) * Integer.parseInt(height);
            }
            catch (NumberFormatException e) {
                a = -1;
            }
            this.area = a;
        } else {
            this.area = -1;
        }
    }

    public String getSrc() {
        return this.src;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getAlt() {
        return this.alt;
    }

    private static String nullTrim(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    public int getArea() {
        return this.area;
    }

    public String toString() {
        return this.src + "\twidth=" + this.width + "\theight=" + this.height + "\talt=" + this.alt + "\tarea=" + this.area;
    }

    @Override
    public int compareTo(Image o) {
        if (o == this) {
            return 0;
        }
        if (this.area > o.area) {
            return -1;
        }
        if (this.area == o.area) {
            return this.src.compareTo(o.src);
        }
        return 1;
    }
}

