/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class StatusCheckerUtil {
    private static final Logger log = LoggerFactory.getLogger(StatusCheckerUtil.class);
    @Autowired
    @Qualifier(value="mnAsyncTask")
    ThreadPoolTaskExecutor asyncJobExecutor;
    @Value(value="${tms.manager.thread.async.core-pool:30}")
    private int corePoolSize;
    @Value(value="${tms.manager.thread.async.max-pool:50}")
    private int maxPoolSize;
    @Value(value="${tms.manager.thread.async.capacity:80}")
    private int queueCapacity;
    @Value(value="${tms.manager.thread.async.timeout:180}")
    private int threadTimeout;
    @Autowired
    @Qualifier(value="mnAsyncJobExecutor")
    ThreadPoolTaskExecutor asyncJobLauncherExecutor;

    public boolean isAsyncThreadStocked(String className) {
        boolean isStock = false;
        int nmActiveCount = this.asyncJobExecutor.getActiveCount();
        int nmTaskQueueSize = this.asyncJobExecutor.getThreadPoolExecutor().getQueue().size();
        isStock = false;
        if (this.maxPoolSize > 0 && nmActiveCount >= this.maxPoolSize) {
            isStock = true;
            isStock = this.queueCapacity == nmTaskQueueSize;
        }
        if (isStock && className != null) {
            log.info("[{}] don't start work. asyncJobLauncher is full. active:{}/maxPool:{}, taskQueueSize:{}/capacity:{}", new Object[]{className, nmActiveCount, this.maxPoolSize, nmTaskQueueSize, nmTaskQueueSize});
        }
        return isStock;
    }

    public String getThreadStatus() {
        int nmActiveCount = this.asyncJobExecutor.getActiveCount();
        int nmTaskQueueSize = this.asyncJobExecutor.getThreadPoolExecutor().getQueue().size();
        return "active:" + nmActiveCount + "/maxPool:" + this.maxPoolSize + ", taskQueueSize:" + nmTaskQueueSize + "/capacity:" + nmTaskQueueSize;
    }

    public boolean isAsyncJobLauncherStocked(String className) {
        boolean isStock = false;
        int nmActiveCount = this.asyncJobLauncherExecutor.getActiveCount();
        int nmTaskQueueSize = this.asyncJobLauncherExecutor.getThreadPoolExecutor().getQueue().size();
        isStock = false;
        if (this.maxPoolSize > 0 && nmActiveCount >= this.maxPoolSize) {
            isStock = true;
            isStock = this.queueCapacity == nmTaskQueueSize;
        }
        if (isStock && className != null) {
            log.info("[{}] don't start work. asyncJobLauncher is full. active:{}/maxPool:{}, taskQueueSize:{}/capacity:{}", new Object[]{className, nmActiveCount, this.maxPoolSize, nmTaskQueueSize, nmTaskQueueSize});
        }
        return isStock;
    }

    public String getAsyncJobLauncherStatus() {
        int nmActiveCount = this.asyncJobLauncherExecutor.getActiveCount();
        int nmTaskQueueSize = this.asyncJobLauncherExecutor.getThreadPoolExecutor().getQueue().size();
        return "active:" + nmActiveCount + "/maxPool:" + this.maxPoolSize + ", taskQueueSize:" + nmTaskQueueSize + "/capacity:" + nmTaskQueueSize;
    }
}

