/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log.sample;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.util.Scanner;

public class FileWatchDog {
    private Scanner scanner;

    public FileWatchDog(String targetDir) {
        ArrayList<File> scanFiles = new ArrayList<File>();
        this.searchSubDirs(targetDir, scanFiles);
        this.scanner = new Scanner();
        this.scanner.setScanInterval(1);
        this.scanner.setScanDirs(scanFiles);
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

            public void fileRemoved(String filename) throws Exception {
                System.out.println(filename + " is deleted");
            }

            public void fileChanged(String filename) throws Exception {
                System.out.println(filename + " is changed");
            }

            public void fileAdded(String filename) throws Exception {
                File f = new File(filename);
                if (f.isDirectory()) {
                    FileWatchDog.this.scanner.addScanDir(f);
                }
                System.out.println(filename + " is added");
            }
        });
    }

    public void start() {
        try {
            this.scanner.start();
        }
        catch (Exception e) {
            new RuntimeException(e);
        }
    }

    private List<File> searchSubDirs(String targetDir, final List<File> dirs) {
        File target = new File(targetDir);
        target.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    dirs.add(file);
                    FileWatchDog.this.searchSubDirs(file.toString(), dirs);
                }
                return false;
            }
        });
        return dirs;
    }

    public static void main(String[] args) throws Exception {
        new FileWatchDog("c:\\test").start();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
            }
        }, 60000L, 60000L);
    }
}

