/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log.sample;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class DirectoryWatchDemo {
    public static Path getModifiedFilePath(WatchKey key) throws InterruptedException {
        return (Path)key.watchable();
    }

    public static void main(String[] args) throws InterruptedException {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 1; i < 1000; ++i) {
                    String path = "";
                    path = i % 2 == 0 ? "E:/test/watchdog/thread1/T1-" + i + ".txt" : "E:/test/watchdog/thread2/T2-" + i + ".txt";
                    this.createFile(path);
                }
            }

            public void createFile(String fileName) {
                try {
                    File file = new File(fileName);
                    FileWriter fw = new FileWriter(file, true);
                    fw.write("\uc548\ub155\ud558\uc138\uc694.");
                    fw.flush();
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try {
            WatchKey key;
            boolean valid;
            WatchService watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get("E:/test/watchdog/thread1", new String[0]);
            Path dir1 = Paths.get("E:/test/watchdog/thread2", new String[0]);
            dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            dir1.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            System.out.println("Watch Service registered for dir: " + dir.getFileName() + " / " + dir1.getFileName());
            do {
                try {
                    key = watcher.take();
                }
                catch (InterruptedException ex) {
                    return;
                }
                Path pathFilePath = DirectoryWatchDemo.getModifiedFilePath(key);
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path fileName = (Path)ev.context();
                    System.out.println(kind.name() + ": " + fileName);
                    System.out.println("pathFilePath+fileName.toString(): " + pathFilePath + File.separator + fileName);
                    System.out.println("fileName.getFileSystem(): " + fileName.toFile().getPath());
                    System.out.println("fileName.getRoot(): " + fileName.getRoot());
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        System.out.println("created file[" + fileName + "]");
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        System.out.println("deleted file[" + fileName + "]");
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    System.out.println("modify file[" + fileName + "]");
                }
            } while (valid = key.reset());
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }
}

