/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.DirectoryWatchDog;
import com.humuson.tms.manager.monitor.log.EventType;
import com.humuson.tms.manager.monitor.log.FileEventListener;
import com.humuson.tms.util.FileUtil;
import com.humuson.tms.util.seq.TimeUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RealTimeDirectoryWatchDog
extends DirectoryWatchDog
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RealTimeDirectoryWatchDog.class);
    private WatchService watcher = null;
    private int initialCount;
    private boolean running = true;
    @Value(value="${tms.manager.monitor.tracking.enable:false}")
    private boolean isTrackingEnable;

    public void stop() {
        this.running = false;
    }

    @PostConstruct
    public void watchingDirectory() throws IOException {
        if (!this.isTrackingEnable) {
            return;
        }
        this.readingDirectorys();
        this.initial(this.directorys);
        new Thread(this).start();
    }

    public synchronized void addDirectory(String pathDir) {
        this.directorys[this.directorys.length] = pathDir;
        try {
            this.lock.lock();
            Paths.get(pathDir, new String[0]).register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (Exception e) {
            log.error("MN1507| fail real time watch directory[{}]", (Object)pathDir, (Object)e);
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
    }

    public void initial(String[] directorys) throws IOException {
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (Exception e) {
                log.error("MN1501| real time direcotry [watcher] close error ", (Throwable)e);
                this.watcher = null;
            }
        }
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            for (String directory : directorys) {
                if (directory.trim().isEmpty()) continue;
                Paths.get(directory, new String[0]).register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                log.info("real time monitor directory = {} ", (Object)directory);
            }
        }
        catch (Exception e) {
            log.error("MN1502| fail directory monitor file system retry..", (Throwable)e);
            try {
                if (this.initialCount++ > 5) {
                    log.error("CM9001| directory monitor file system. don't watch real time directorys continue..");
                } else {
                    this.initial(directorys);
                }
            }
            catch (Exception e2) {
                log.error("CM1500| Please contact the manager.");
            }
        }
    }

    private Path getModifiedFilePath(WatchKey key) throws InterruptedException {
        return (Path)key.watchable();
    }

    private void registFileListener(String directory, String fileName, WatchEvent.Kind<?> kind) {
        String fullPathFileName = FileUtil.lastSeparator((String)directory) + fileName;
        try {
            for (FileEventListener fileEventListener : this.fileEventListeners) {
                if (!this.detectDirectory(fileEventListener.workDirectory(), directory) || !fileEventListener.detectFilePattern(fileName)) continue;
                EventType type = null;
                if (this.detectCreateEvent(fileEventListener, kind)) {
                    type = EventType.CREATE;
                } else if (this.detectDeleteEvent(fileEventListener, kind)) {
                    type = EventType.DELETE;
                } else {
                    log.warn("MN1501| this file[{}] event is not include create|delete type", (Object)fullPathFileName);
                    return;
                }
                this.notifyFileEventListener(fileEventListener, new File(fullPathFileName), type);
            }
        }
        catch (Exception e) {
            log.error("MN5101| fileEventListener loop error so failed file[{}] event adding", (Object)fullPathFileName, (Object)e);
        }
    }

    private boolean detectDirectory(String workDirectory, String directory) {
        return Paths.get(workDirectory, new String[0]).compareTo(Paths.get(directory, new String[0])) == 0;
    }

    private boolean detectCreateEvent(FileEventListener fileEventListener, WatchEvent.Kind<?> kind) {
        return kind == StandardWatchEventKinds.ENTRY_CREATE && fileEventListener.isCreateListen();
    }

    private boolean detectDeleteEvent(FileEventListener fileEventListener, WatchEvent.Kind<?> kind) {
        return kind == StandardWatchEventKinds.ENTRY_DELETE && fileEventListener.isDeleteListen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void directoryWatching() {
        errorCount = 0;
        while (this.running) {
            key = null;
            try {
                key = this.watcher.take();
                if (key == null) {
                    RealTimeDirectoryWatchDog.log.info("watcher is null");
                    Thread.sleep(100L);
                    continue;
                }
                ** break block19
                catch (ClosedWatchServiceException ce) {
                    RealTimeDirectoryWatchDog.log.error("MN1503| close watch service retry watching", (Throwable)ce);
                }
            }
            catch (Exception e) {
                RealTimeDirectoryWatchDog.log.error("CM9000| watcher take interrupted error", (Throwable)e);
                if (++errorCount > 5) {
                }
                TimeUtil.mileSecondsLockSleep((int)200);
            }
lbl-1000:
            // 1 sources

            {
                try {
                    pathFilePath = this.getModifiedFilePath(key);
                    for (WatchEvent<?> event : key.pollEvents()) {
                        kind = event.kind();
                        ev = event;
                        filePath = (Path)ev.context();
                        directory = pathFilePath.toString();
                        fileName = filePath.getFileName().toString();
                        fullPathFileName = FileUtil.lastSeparator((String)directory) + filePath;
                        if (RealTimeDirectoryWatchDog.log.isDebugEnabled()) {
                            RealTimeDirectoryWatchDog.log.debug("monitor directory event={} file name[{}]", (Object)kind.name(), (Object)fullPathFileName);
                        }
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        this.registFileListener(directory, fileName, kind);
                    }
                    continue;
                }
                catch (InterruptedException e) {
                    RealTimeDirectoryWatchDog.log.error("MN5102| watch eventing Interruted error", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    RealTimeDirectoryWatchDog.log.error("MN5103| watch eventing Interruted error", (Throwable)e);
                    continue;
                }
            }
            finally {
                if (key.reset()) continue;
                RealTimeDirectoryWatchDog.log.warn("don't watching key reset ");
                break;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                this.directoryWatching();
                log.error("watching directory loop end. retry..");
                continue;
            }
            catch (Exception e) {
                log.error("watching directory loop error", (Throwable)e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(100L);
                    this.initial(this.directorys);
                }
                catch (Exception e2) {
                    log.error("MN1530| watching re initial error", (Throwable)e2);
                }
                continue;
            }
            break;
        }
    }
}

