/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FileEventer;
import com.humuson.tms.manager.monitor.log.FileTailerListener;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Queue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTailer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileTailer.class);
    private static final int DEFAULT_DELAY_MILLIS = 1000;
    private static final String RAF_MODE = "r";
    private static final int DEFAULT_BUFSIZE = 4096;
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private final byte[] inbuf;
    private final File file;
    private final Charset cset;
    private final long delayMillis;
    private final boolean end;
    private final FileTailerListener listener;
    private final boolean reOpen;
    private volatile boolean run = true;
    private long readPosition = 0L;
    private Queue<FileEventer> queue = null;

    public FileTailer(File file, FileTailerListener listener) {
        this(file, listener, 1000L);
    }

    public FileTailer(File file, FileTailerListener listener, long delayMillis) {
        this(file, listener, delayMillis, false);
    }

    public FileTailer(File file, FileTailerListener listener, long delayMillis, boolean end) {
        this(file, listener, delayMillis, end, 4096);
    }

    public FileTailer(File file, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen) {
        this(file, listener, delayMillis, end, reOpen, 4096);
    }

    public FileTailer(File file, FileTailerListener listener, long delayMillis, boolean end, int bufSize) {
        this(file, listener, delayMillis, end, false, bufSize);
    }

    public FileTailer(File file, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        this(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public FileTailer(File file, Charset cset, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        this.file = file;
        this.delayMillis = delayMillis;
        this.end = end;
        this.inbuf = new byte[bufSize];
        this.listener = listener;
        listener.init(this);
        this.reOpen = reOpen;
        this.cset = cset;
    }

    public void setReadPosition(long position) {
        log.info("file set position is {}", (Object)position);
        this.readPosition = position;
    }

    public void setFileQueue(Queue<FileEventer> tempQueue) {
        this.queue = tempQueue;
    }

    public static FileTailer create(File file, FileTailerListener listener, long delayMillis, boolean end, int bufSize) {
        return FileTailer.create(file, listener, delayMillis, end, false, bufSize);
    }

    public static FileTailer create(File file, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        return FileTailer.create(file, DEFAULT_CHARSET, listener, delayMillis, end, reOpen, bufSize);
    }

    public static FileTailer create(File file, Charset charset, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen, int bufSize) {
        FileTailer tailer = new FileTailer(file, charset, listener, delayMillis, end, reOpen, bufSize);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static FileTailer create(File file, FileTailerListener listener, long delayMillis, boolean end) {
        return FileTailer.create(file, listener, delayMillis, end, 4096);
    }

    public static FileTailer create(File file, FileTailerListener listener, long delayMillis, boolean end, boolean reOpen) {
        return FileTailer.create(file, listener, delayMillis, end, reOpen, 4096);
    }

    public static FileTailer create(File file, FileTailerListener listener, long delayMillis) {
        return FileTailer.create(file, listener, delayMillis, false);
    }

    public static FileTailer create(File file, FileTailerListener listener) {
        return FileTailer.create(file, listener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean getRun() {
        return this.run;
    }

    public long getDelay() {
        return this.delayMillis;
    }

    @Override
    public void run() {
        this.readingFileLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readingFileLine() {
        RandomAccessFile reader = null;
        try {
            long last = 0L;
            long position = 0L;
            while (this.getRun() && reader == null) {
                try {
                    reader = new RandomAccessFile(this.file, RAF_MODE);
                }
                catch (FileNotFoundException e) {
                    this.listener.fileNotFound();
                }
                if (reader == null) {
                    Thread.sleep(this.delayMillis);
                    continue;
                }
                position = this.end ? this.file.length() : 0L;
                last = this.file.lastModified();
                if (this.readPosition != 0L) {
                    reader.seek(this.readPosition);
                    continue;
                }
                reader.seek(position);
            }
            while (this.getRun()) {
                boolean newer = FileUtils.isFileNewer((File)this.file, (long)last);
                long length = this.file.length();
                if (length < position) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile save = reader;
                        reader = new RandomAccessFile(this.file, RAF_MODE);
                        try {
                            this.readLines(save);
                        }
                        catch (IOException ioe) {
                            this.listener.handle(ioe);
                        }
                        position = 0L;
                        IOUtils.closeQuietly((Closeable)save);
                    }
                    catch (FileNotFoundException e) {
                        this.listener.fileNotFound();
                    }
                    continue;
                }
                if (length > position) {
                    position = this.readLines(reader);
                    last = this.file.lastModified();
                } else if (newer) {
                    position = 0L;
                    reader.seek(position);
                    position = this.readLines(reader);
                    last = this.file.lastModified();
                }
                if (this.reOpen) {
                    IOUtils.closeQuietly((Closeable)reader);
                }
                Thread.sleep(this.delayMillis);
                if (this.getRun() && this.reOpen) {
                    reader = new RandomAccessFile(this.file, RAF_MODE);
                    reader.seek(position);
                }
                if (!this.file.canWrite() || this.listener.getFileQueue().size() < 1) continue;
                this.listener.endOfFileReached();
                break;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.stop(e);
        }
        catch (Exception e) {
            this.stop(e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private void stop(Exception e) {
        this.listener.handle(e);
        this.stop();
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile reader) throws IOException {
        int num;
        long pos;
        ByteArrayOutputStream lineBuf = new ByteArrayOutputStream(64);
        long rePos = pos = reader.getFilePointer();
        boolean seenCR = false;
        while (this.getRun() && (num = reader.read(this.inbuf)) != -1) {
            block5: for (int i = 0; i < num; ++i) {
                byte ch = this.inbuf[i];
                switch (ch) {
                    case 10: {
                        seenCR = false;
                        if (this.listener == null) {
                            System.out.println("listener is null");
                        }
                        this.listener.handle(new String(lineBuf.toByteArray(), this.cset), rePos);
                        lineBuf.reset();
                        rePos = pos + (long)i + 1L;
                        continue block5;
                    }
                    case 13: {
                        if (seenCR) {
                            lineBuf.write(13);
                        }
                        seenCR = true;
                        continue block5;
                    }
                    default: {
                        if (seenCR) {
                            seenCR = false;
                            this.listener.handle(new String(lineBuf.toByteArray(), this.cset), rePos);
                            lineBuf.reset();
                            rePos = pos + (long)i + 1L;
                        }
                        lineBuf.write(ch);
                    }
                }
            }
            pos = reader.getFilePointer();
        }
        IOUtils.closeQuietly((OutputStream)lineBuf);
        reader.seek(rePos);
        this.readPosition = rePos;
        log.debug("file[{}] line last seek[{}] ", (Object)this.file.getName(), (Object)rePos);
        return rePos;
    }
}

