/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.monitor.log;

import com.humuson.tms.manager.monitor.log.FinishFileController;
import java.io.File;
import java.io.FileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ControllerBackupFile {
    private static final Logger log = LoggerFactory.getLogger(ControllerBackupFile.class);
    protected File backupFile;
    private FileWriter writer = null;
    public boolean append = false;
    @Autowired
    protected FinishFileController changeFileNameController;

    public void init(File file, boolean append) {
        this.append = append;
        this.backupFile = file;
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = new FileWriter(file, append);
        }
        catch (Exception e) {
            log.error("MN1507| failed create backup file[{}] writer, error:{} ", (Object)file.getName(), (Object)e);
        }
    }

    public void writePosition(long position) {
        if (this.ifAppendFirstLineSkip()) {
            return;
        }
        try {
            this.writer.write("\n");
            this.writer.write("" + position);
            this.writer.flush();
        }
        catch (Exception e) {
            log.error("MN1508| error write file[{}] postion[{}] so init(), error:{}", new Object[]{this.backupFile.getName(), position, e});
            this.init(this.backupFile, true);
        }
    }

    private boolean ifAppendFirstLineSkip() {
        if (this.append) {
            this.append = false;
            return true;
        }
        return false;
    }

    public void finish() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            Thread.sleep(500L);
        }
        catch (Exception e2) {
            log.error("CM3000| file stream close error, error:{}", (Throwable)e2);
        }
        this.changeFileNameController.finish(this.backupFile, this.finishChangeFile());
        log.info("backup file change to {}", (Object)this.finishChangeFile());
    }

    public abstract File finishChangeFile();
}

