/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.handler;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.result.ResultRedis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class ResultRedisHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultRedisHandler.class);
    @Autowired
    LockContexter contexter;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    @Qualifier(value="emailError")
    Map<String, String> emailErrorCodes;
    @Autowired
    @Qualifier(value="pushError")
    Map<String, String> pushErrorCodes;
    @Autowired
    @Qualifier(value="smsError")
    Map<String, String> smsErrorCodes;
    @Autowired
    @Qualifier(value="bizError")
    Map<String, String> bizErrorCodes;
    @Autowired
    @Qualifier(value="tmsError")
    Map<String, String> tmsErrorCodes;
    @Autowired
    private ResultRedis processResultService;
    @Value(value="${tms.manager.proc-result.row-stand.scan-cnt}")
    private int PROC_MIN_COUNT;
    @Value(value="${tms.manager.proc-result.row-stand.max-cnt}")
    private int PROC_MAX_COUNT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="mnAsyncTask")
    public void process(boolean isOverOfDropIntervalMinute, String crsltResultKey) {
        block18: {
            long start = System.currentTimeMillis();
            LockController lockController = this.contexter.lock("lock.manager.result.handler." + crsltResultKey);
            Map<String, String> crsltsInfo = new HashMap();
            try {
                lockController.lock();
                log.info("LOCK[{}] start", (Object)("lock.manager.result.handler." + crsltResultKey));
                crsltsInfo = this.wrapperRedisTemplate.hscan(crsltResultKey, "", this.PROC_MIN_COUNT, this.PROC_MAX_COUNT);
                if (!crsltsInfo.isEmpty()) {
                    String[] crsltKeys = crsltResultKey.split(":");
                    List<Map<String, String>> mergeCrsltAndTlists = this.makeResultObj(crsltResultKey, crsltsInfo, crsltKeys[1]);
                    if (ObjectUtils.isEmpty(mergeCrsltAndTlists)) {
                        log.error("make result object is null or empty. REDIS_CRSLT[key={}], CRSLTS INFO[{}] ", (Object)crsltResultKey, crsltsInfo);
                        return;
                    }
                    try {
                        for (Map<String, String> result : mergeCrsltAndTlists) {
                            log.info("CRSLT[KEY={} / FIELD={}] RESULT INFO TLIST=[KEY={} / FIELD={}]", new Object[]{crsltResultKey, result.containsKey("CRSLT_FIELD") ? result.get("CRSLT_FIELD") : result, result.containsKey("TLIST_KEY") ? result.get("TLIST_KEY") : result, result.containsKey("TLIST_FIELD") ? result.get("TLIST_FIELD") : result});
                        }
                        log.info("merged CRSLT&TLIST key=[{}], is drop=[{}]", (Object)crsltResultKey, (Object)isOverOfDropIntervalMinute);
                        this.redisToDb(isOverOfDropIntervalMinute, crsltResultKey, mergeCrsltAndTlists);
                        break block18;
                    }
                    catch (Exception e) {
                        log.error("CRSLT[key={}]], failed merge CRSLT&TLIST error", (Object)crsltResultKey, (Object)e);
                        break block18;
                    }
                    finally {
                        if (mergeCrsltAndTlists != null) {
                            mergeCrsltAndTlists.clear();
                        }
                    }
                }
                if (isOverOfDropIntervalMinute) {
                    this.wrapperRedisTemplate.del(crsltResultKey);
                    return;
                }
            }
            catch (Exception e) {
                log.error("CRSLT process error. result key={} read error", (Object)crsltResultKey, (Object)e);
            }
            finally {
                if (lockController != null) {
                    lockController.unLock();
                }
                if (crsltsInfo != null) {
                    crsltsInfo.clear();
                }
            }
        }
    }

    private String getChannelFromCRSLT(String[] crsltKeys) {
        return crsltKeys[1];
    }

    public List<Map<String, String>> makeResultObj(String crsltKey, Map<String, String> targetMap, String channelType) {
        Map<Object, Object> errorChannelCode = new HashMap();
        HashMap<String, String> tmsErrorCode = new HashMap();
        if (channelType.equals(Constants.ChannelType.EM.toString())) {
            errorChannelCode = this.emailErrorCodes;
        } else if (channelType.equals(Constants.ChannelType.SM.toString())) {
            errorChannelCode = this.smsErrorCodes;
        } else if (channelType.equals(Constants.ChannelType.PU.toString()) || channelType.equals("XP")) {
            errorChannelCode = this.pushErrorCodes;
        } else if (channelType.equals(Constants.ChannelType.KA.toString())) {
            errorChannelCode = this.bizErrorCodes;
        }
        tmsErrorCode = this.tmsErrorCodes;
        return this.processResultService.makeResultObj(crsltKey, targetMap, tmsErrorCode, errorChannelCode);
    }

    public void redisToDb(boolean isDrop, String crsltKey, List<Map<String, String>> resultMapList) {
        this.processResultService.recordLog(isDrop, crsltKey, resultMapList);
    }
}

