/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.result;

import com.humuson.tms.manager.custom.repository.model.ResultBiztalkModel;
import com.humuson.tms.manager.result.ResultBiztalk;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

@Component
public class ResultImcBiztalk
implements ResultBiztalk {
    private static final Logger log = LoggerFactory.getLogger(ResultImcBiztalk.class);
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    @Qualifier(value="resultImcBiztalkReader")
    public MyBatisPagingItemReader<ResultBiztalkModel> resultImcBiztalkReader;
    @Autowired
    @Qualifier(value="resultImcBiztalkWriter")
    public ItemWriter<ResultBiztalkModel> resultImcBiztalkWriter;
    @Value(value="${tms.manager.proc-result-ka.fixed-table.flag}")
    private String fixedTableFlag;
    @Value(value="${tms.manager.proc-result-ka.fixed-table.name}")
    private String fixedTableName;
    @Value(value="${tms.manager.proc-result-ka.fixed-table.format}")
    private String fixedTableFormat;
    private static final int CHUNK_SIZE = 1000;

    @Override
    public Step step1() {
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setPropagationBehavior(Propagation.REQUIRES_NEW.value());
        attribute.setIsolationLevel(Isolation.READ_COMMITTED.value());
        return this.stepBuilderFactory.get("resultKaStep").chunk(1000).reader(this.resultImcBiztalkReader).writer(this.resultImcBiztalkWriter).transactionAttribute((TransactionAttribute)attribute).build();
    }

    @Override
    public List<String> makeTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        if ("Y".equals(this.fixedTableFlag)) {
            tableList.add(this.fixedTableName);
        } else {
            log.error("[ResultKaServiceImpl] biztalk use fixed table name");
        }
        return tableList;
    }
}

