/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.BatchSqlExecutor;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao;
import com.humuson.tms.manager.custom.stat.openclick.StatOpenClickInfo;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent(value="StatUniqOpenClickWriter")
@StepScope
public class StatUniqOpenClickWriter
implements ItemWriter<StatOpenClickInfo> {
    private static final Logger log = LoggerFactory.getLogger(StatUniqOpenClickWriter.class);
    @Autowired
    BatchSqlExecutor<StatOpenClickInfo> sqlExecutor;
    @Autowired
    SqlSessionFactory sqlSessionFactory;

    public void write(List<? extends StatOpenClickInfo> items) {
        long start = System.currentTimeMillis();
        log.info("[JOB_WRITER] START updateUniqOpenClickStat. selected size:{}", (Object)items.size());
        List<? extends StatOpenClickInfo> resultList = items;
        for (StatOpenClickInfo statOpenClickInfo : resultList) {
            log.info("sendId:{}, schdId:{}, workday:{}, openCnt:{}, clickCnt:{}, uniqOpenCnt:{}, uniqClickCnt:{}, lastSendListId:{}", new Object[]{statOpenClickInfo.getSEND_ID(), statOpenClickInfo.getSCHD_ID(), statOpenClickInfo.getWORKDAY(), statOpenClickInfo.getOPEN_CNT(), statOpenClickInfo.getCLICK_CNT(), statOpenClickInfo.getUNIQ_OPEN_CNT(), statOpenClickInfo.getUNIQ_CLICK_CNT(), statOpenClickInfo.getLAST_SEND_LIST_ID()});
        }
        try {
            long startDb = System.currentTimeMillis();
            this.sqlExecutor.batchUpdate("com.humuson.tms.manager.custom.stat.dao.StatOpenClickDao.updateUniqOpenClickStat", resultList, false);
            long endDb = System.currentTimeMillis();
            log.info("[QUERY] batch updateUniqOpenClickStat, size:{} END ============[{}] seconds", (Object)resultList.size(), (Object)((double)(endDb - startDb) / 1000.0));
        }
        catch (Exception e) {
            log.error("updateUniqOpenClickStat Bulk insert Error. start each update. {}", (Object)e.getMessage());
            long l = System.currentTimeMillis();
            SqlSession sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE);
            StatOpenClickDao statOpenClickDao = (StatOpenClickDao)sqlSession.getMapper(StatOpenClickDao.class);
            for (StatOpenClickInfo statOpenClickInfo : resultList) {
                try {
                    statOpenClickDao.updateUniqOpenClickStat(statOpenClickInfo);
                }
                catch (Exception e1) {
                    log.error("updateUniqOpenClickStat Single insert Error : {}, {}", (Object)statOpenClickInfo.toString(), (Object)e1);
                }
            }
            if (sqlSession != null) {
                sqlSession.commit(true);
                sqlSession.close();
            }
            long endDb = System.currentTimeMillis();
            log.info("[QUERY] single updateUniqOpenClickStat size:{} END ============[{}] seconds", (Object)resultList.size(), (Object)((double)(endDb - l) / 1000.0));
        }
        long end = System.currentTimeMillis();
        log.info("[JOB_WRITER] END updateUniqOpenClickStat. size:{} [{}] seconds", (Object)items.size(), (Object)((double)(end - start) / 1000.0));
    }
}

