/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.writer;

import com.google.gson.Gson;
import com.humuson.tms.adaptor.jdbc.mybatis.BatchSqlExecutor;
import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.manager.custom.repository.dao.ResultSendListDao;
import com.humuson.tms.manager.custom.repository.model.ResultWebModel;
import com.humuson.tms.manager.repository.model.FatigueModel;
import com.humuson.tms.util.date.DateUtil;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@TmsComponent(value="resultSendListWriter")
@StepScope
public class ResultSendListWriter
implements ItemWriter<ResultWebModel> {
    private static final Logger log = LoggerFactory.getLogger(ResultSendListWriter.class);
    @Autowired
    ResultSendListDao resultSendListDao;
    @Autowired
    SqlSessionFactory batchSqlSessionFactory;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    BatchSqlExecutor<ResultWebModel> batchSqlExecutor;
    private static final String INSERT_SEND_LIST_RESULT = "com.humuson.tms.manager.custom.repository.dao.ResultSendListDao.insertSendListResult";
    private static final String UPDATE_SEND_LIST_FLAG = "com.humuson.tms.manager.custom.repository.dao.ResultSendListDao.updateSendListFlagCheck";

    @BeforeStep
    public void before() {
    }

    private void insertSendListResult(List<ResultWebModel> resultList) throws Exception {
        long start = System.currentTimeMillis();
        try {
            List fails = this.batchSqlExecutor.batchUpdateResponse(INSERT_SEND_LIST_RESULT, resultList, true).getFails();
            if (fails != null && fails.size() > 0) {
                resultList.remove(fails);
            }
        }
        catch (Exception e) {
            log.error("insertSendListResult error resultList size={} data[{}]. error:{}", new Object[]{resultList.size(), resultList.toArray().toString(), e});
            throw e;
        }
        finally {
            long end = System.currentTimeMillis();
            log.info("[QUERY] batch insertSendListResult size:{} END ============[{}] seconds", (Object)resultList.size(), (Object)((double)(end - start) / 1000.0));
        }
    }

    private void updateSendListResult(List<ResultWebModel> resultList) {
        long start = System.currentTimeMillis();
        try {
            this.batchSqlExecutor.batchUpdateResponse(UPDATE_SEND_LIST_FLAG, resultList, true);
        }
        catch (Exception e) {
            log.error("[ResultSendListWriter] updateSendListFlagCheck error. size={} data[{}], e:{}", new Object[]{resultList.size(), resultList, e});
        }
        long end = System.currentTimeMillis();
        log.info("[QUERY] batch updateSendListFlagCheck size:{} END ============[{}] seconds", (Object)resultList.size(), (Object)((double)(end - start) / 1000.0));
    }

    public void write(List<? extends ResultWebModel> items) {
        long start = System.currentTimeMillis();
        log.info("[JOB_WRITER] START insertWebResult - selected size:{}", (Object)items.size());
        try {
            this.insertSendListResult(items);
            this.updateSendListResult(items);
        }
        catch (Exception e) {
            log.error("K001 | insertWebResult process error. don't update process. {}", (Throwable)e);
        }
        try {
            CopyOnWriteArrayList<String> fatigueList = new CopyOnWriteArrayList<String>();
            for (ResultWebModel result : items) {
                ResultWebModel rwm = new ResultWebModel();
                if (!Constants.EventType.S.toString().equals(rwm.getSendListEvnetType()) || !"Y".equalsIgnoreCase(rwm.getSendListFatigueYn()) || !"01".equals(rwm.getSendCode())) continue;
                fatigueList.add(rwm.getChannelType().concat("|").concat(rwm.getMemberId()).concat("|").concat(rwm.getSiteId()));
            }
            if (fatigueList.size() > 0) {
                this.fatigueListProcess(fatigueList);
            }
        }
        catch (Exception e) {
            log.error("make webResult model process Error : {} ", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        log.info("[JOB_WRITER] END insertWebResult size:{} [{}] seconds", (Object)items.size(), (Object)((double)(end - start) / 1000.0));
    }

    private void fatigueListProcess(List<String> fatigueList) throws Exception {
        log.info("Fatigue data size : {}", (Object)fatigueList.size());
        long start = System.currentTimeMillis();
        String key = null;
        String value = null;
        String memberId = null;
        String[] fatigueTarget = null;
        for (String fatigueData : fatigueList) {
            fatigueTarget = fatigueData.split("\\|");
            key = "MFATI".concat(":").concat(DateUtil.getFullDate((String)"yyyyMMdd")).concat(":").concat(fatigueTarget[2]);
            if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)fatigueTarget[1])) {
                log.info("fatigue target data is wrong : key {} / fatigue Data ] channel Type: {} | memberId: {} | site ID: {}", new Object[]{key, fatigueTarget[0], fatigueTarget[1], fatigueTarget[2]});
                continue;
            }
            memberId = fatigueTarget[1];
            value = this.wrapperRedisTemplate.hmget(key, memberId);
            FatigueModel fatiqueModel = null;
            if (!StringUtils.isEmpty((Object)value)) {
                Gson gson = new Gson();
                fatiqueModel = (FatigueModel)gson.fromJson(value, FatigueModel.class);
            } else {
                fatiqueModel = new FatigueModel();
            }
            switch (fatigueTarget[0]) {
                case "EM": {
                    fatiqueModel.setEM(fatiqueModel.getEM() + 1);
                    break;
                }
                case "KA": {
                    fatiqueModel.setKA(fatiqueModel.getKA() + 1);
                    break;
                }
                case "SM": {
                    fatiqueModel.setSM(fatiqueModel.getSM() + 1);
                    break;
                }
                case "PU": {
                    fatiqueModel.setPU(fatiqueModel.getPU() + 1);
                    break;
                }
            }
            fatiqueModel.createFatigueModel();
            this.wrapperRedisTemplate.hmset(key, memberId, fatiqueModel.getRedisVaule());
        }
        long end = System.currentTimeMillis();
        log.info("[REDIS] redis upload fatigueList size:{} END ============[{}] seconds", (Object)fatigueList.size(), (Object)((double)(end - start) / 1000.0));
        if (fatigueList != null) {
            fatigueList.clear();
        }
    }
}

