/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.custom.batch.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;

public abstract class ResultJobListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(ResultJobListener.class);

    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            // empty if block
        }
        long minId = jobExecution.getJobParameters().getLong("minId");
        long maxId = jobExecution.getJobParameters().getLong("maxId");
        try {
            long time = jobExecution.getJobParameters().getLong("time");
            log.info("[JOB] END [{}], job id {} minId:{},maxId:{}, state {} END [{}] seconds", new Object[]{this.getChannelName(), jobExecution.getId(), minId, maxId, jobExecution.getStatus(), (double)(System.currentTimeMillis() - time) / 1000.0});
        }
        catch (Exception e) {
            log.error("batch job after process[{}], error:{}", (Object)this.getChannelName(), (Object)e);
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        long minId = jobExecution.getJobParameters().getLong("minId");
        long maxId = jobExecution.getJobParameters().getLong("maxId");
        log.info("[JOB] START batch before job [{}] job id {} minId {} maxId {} START", new Object[]{this.getChannelName(), jobExecution.getId(), minId, maxId});
    }

    protected abstract String getChannelName();
}

