/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class MnAsyncTaskExecutor {
    @Value(value="${tms.manager.thread.async.core-pool}")
    private int corePoolSize;
    @Value(value="${tms.manager.thread.async.max-pool}")
    private int maxPoolSize;
    @Value(value="${tms.manager.thread.async.capacity}")
    private int queueCapacity;
    @Value(value="${tms.manager.thread.async.timeout}")
    private int threadTimeout;

    @Bean(value={"mnAsyncTask"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.threadTimeout);
        threadPoolTaskExecutor.setThreadNamePrefix("mnAsyncTask-");
        return threadPoolTaskExecutor;
    }

    @Bean(value={"mnStatTask"})
    public ThreadPoolTaskExecutor threadPoolStatTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.threadTimeout);
        threadPoolTaskExecutor.setThreadNamePrefix("mnStatTask-");
        return threadPoolTaskExecutor;
    }
}

