/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.clean;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.manager.clean.Clean;
import com.humuson.tms.manager.repository.dao.CleanDao;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent(value="CleanBasicRedis")
public class CleanBasicRedis
implements Clean {
    private static final Logger log = LoggerFactory.getLogger(CleanBasicRedis.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    CleanDao cleanDao;
    @Autowired
    private LockContexter contexter;
    @Value(value="${tms.manager.clean.redis.holding-day-min}")
    private int cleanRedisHoldingDayMin;
    @Value(value="${tms.manager.clean.redis.holding-day-max}")
    private int cleanRedisHoldingDayMax;
    @Value(value="${tms.manager.proc-stat.stat-limit-day}")
    private int statLimitDay;

    @Override
    public void cleanData() {
        long start = System.currentTimeMillis();
        String todays = DateUtil.getWorkday();
        int toDate = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.cleanRedisHoldingDayMin)));
        int fromDate = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.cleanRedisHoldingDayMax)));
        List<SchdInfoModel> schdList = this.cleanDao.selectCleanSchd(toDate, fromDate);
        ArrayList<String> schdIdList = new ArrayList<String>();
        if (schdList.size() > 0) {
            for (SchdInfoModel sim : schdList) {
                String pinfokey;
                String schdId;
                block13: {
                    schdId = Long.toString(sim.getSchdId());
                    pinfokey = "PINFO:" + schdId;
                    try {
                        if (!this.wrapperRedisTemplate.hasKey(pinfokey)) {
                            log.debug("[cleanData] This PINFO key is empty [{}]", (Object)pinfokey);
                        }
                        break block13;
                    }
                    catch (Exception e1) {
                        log.warn("[cleanData] pinfokey {} e1 {}", (Object)pinfokey, (Object)e1);
                    }
                    continue;
                }
                String cycleType = sim.getCycleType();
                if ("Y".equalsIgnoreCase(sim.getSendDelYn()) || "Y".equalsIgnoreCase(sim.getSchdDelYn())) {
                    schdIdList.add(pinfokey);
                    continue;
                }
                if (cycleType != null && cycleType.startsWith("O") && this.checkLimitDay(sim.getWorkday(), sim.getTrackingYn(), sim.getTrackingClose(), sim.getSchdJobStatus())) {
                    schdIdList.add(pinfokey);
                    log.debug("schd {} is {} and tracking over", (Object)schdId, (Object)cycleType);
                    continue;
                }
                if (cycleType != null && (cycleType.startsWith("C") || cycleType.startsWith("F")) && (Long.parseLong(sim.getWorkday() + 1) < Long.parseLong(todays) || "N".equalsIgnoreCase(sim.getUseYn()))) {
                    schdIdList.add(pinfokey);
                    log.debug("schd {} is {} and use N", (Object)schdId, (Object)cycleType);
                    continue;
                }
                if (cycleType != null) continue;
                schdIdList.add(pinfokey);
                log.debug("cycleType is null. schd {} is {}.", (Object)schdId, (Object)cycleType);
            }
            log.info("[cleanData] schdIdList {}", (Object)schdIdList.size());
            if (schdIdList.size() > 0) {
                for (String schdIdStr : schdIdList) {
                    this.wrapperRedisTemplate.del(schdIdStr);
                    log.warn("[REDIS_DELETE] {} ", (Object)schdIdStr);
                }
            }
            List mfatiKeyList = this.wrapperRedisTemplate.scan("MFATI", 100, 1000);
            log.info("mfatiKeyList size {}", (Object)mfatiKeyList.size());
            if (mfatiKeyList.size() > 0) {
                int delM3Day = Integer.parseInt(DateUtil.getDateCalculationDay((String)"yyyymmdd", (int)-3));
                for (String mfatiKey : mfatiKeyList) {
                    String[] mfatiKeys = mfatiKey.split(":");
                    if (mfatiKeys[1] == null || Integer.parseInt(mfatiKeys[1]) > delM3Day) continue;
                    this.wrapperRedisTemplate.del(mfatiKey);
                    log.warn("[REDIS_DELETE] {}", (Object)mfatiKey);
                }
            }
        } else {
            log.info("schdList.size() :: [{}]", (Object)schdList.size());
        }
        long end = System.currentTimeMillis();
        log.info("[cleanData] END [{}] seconds", (Object)((double)(end - start) / 1000.0));
    }

    private boolean checkLimitDay(String workday, String trackingYn, String trackingClose, String jobStatus) {
        long today = Long.parseLong(DateUtil.getWorkday());
        long targetDay = Long.parseLong(workday);
        if ("Y".equalsIgnoreCase(trackingYn) || "A".equalsIgnoreCase(trackingYn) || "O".equalsIgnoreCase(trackingYn)) {
            targetDay = Long.parseLong(trackingClose) + (long)this.statLimitDay;
        } else if ("40".equalsIgnoreCase(jobStatus) || "41".equalsIgnoreCase(jobStatus) || "42".equalsIgnoreCase(jobStatus) || "43".equalsIgnoreCase(jobStatus)) {
            targetDay += (long)this.statLimitDay;
        }
        return targetDay <= today;
    }
}

