/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.task;

import com.humuson.tms.adaptor.jdbc.mybatis.BatchSqlExecutor;
import com.humuson.tms.manager.repository.dao.CleanRdbDao;
import com.humuson.tms.util.date.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="cleanRecordTasklet")
@StepScope
public class CleanRecordBasicTasklet
implements Tasklet {
    private static final Logger log = LoggerFactory.getLogger(CleanRecordBasicTasklet.class);
    @Autowired
    CleanRdbDao cleanRdbDao;
    @Autowired
    BatchSqlExecutor<Long> sqlExecutor;
    @Value(value="${tms.manager.clean.rdb.limit-day}")
    private int limitDay;
    @Value(value="${tms.manager.clean.rdb.include-web}")
    private String includeWeb;
    @Value(value="${tms.manager.clean.rdb.include-temp}")
    private String includeTemp;
    String PARTITION_HEADER = "P_";

    public RepeatStatus execute(StepContribution arg0, ChunkContext arg1) throws Exception {
        log.info("[cleanRecordTasklet] limitDay {} includeWeb {} includeTemp {}", new Object[]{this.limitDay, this.includeWeb, this.includeTemp});
        String targetDay = DateUtil.getDateCalculationDay((String)"yyyyMMdd", (int)(-this.limitDay));
        String partitionName = this.PARTITION_HEADER + targetDay;
        try {
            this.cleanRdbDao.dropPartitionSendList(partitionName);
        }
        catch (Exception e) {
            log.error("MN1603|Partition Drop Error : send_list : {}, error:{}", (Object)partitionName, (Object)e);
        }
        try {
            this.cleanRdbDao.dropPartitionSendListFlag(partitionName);
        }
        catch (Exception e) {
            log.error("MN1603|Partition Drop Error : send_list_flag : {}, error:{}", (Object)partitionName, (Object)e);
        }
        if ("Y".equals(this.includeWeb)) {
            try {
                this.cleanRdbDao.dropPartitionWebResult(partitionName);
            }
            catch (Exception e) {
                log.error("MN1603|Partition Drop Error : web_result : {}, error:{}", (Object)partitionName, (Object)e);
            }
        }
        if ("T".equals(this.includeTemp)) {
            try {
                this.cleanRdbDao.truncateTargetTemp();
            }
            catch (Exception e) {
                log.error("MN1604|Truncate Error : target_temp, error:{}", (Throwable)e);
            }
        }
        if ("D".equals(this.includeTemp)) {
            try {
                this.cleanRdbDao.dropPartitionTargetTemp(partitionName);
            }
            catch (Exception e) {
                log.error("MN1603|Partition Drop Error : target_temp, error:{}", (Throwable)e);
            }
        }
        return RepeatStatus.FINISHED;
    }
}

