/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.listener;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.manager.repository.dao.StatDao;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="StatJobListener")
public class StatJobListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(StatJobListener.class);
    @Autowired
    StatDao statDao;
    @Autowired
    private LockContexter contexter;
    private LockController lockController = null;
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;

    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            // empty if block
        }
        long schdId = jobExecution.getJobParameters().getLong("schdId");
        long sendId = jobExecution.getJobParameters().getLong("sendId");
        String lockKey = jobExecution.getJobParameters().getString("lockKey");
        this.lockController.unLock();
        try {
            if (this.wrapperRedisTemplate.hasKey(lockKey)) {
                this.wrapperRedisTemplate.del(lockKey);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long endTime = System.currentTimeMillis();
        long startTime = 0L;
        Iterator stepExecutionIter = jobExecution.getStepExecutions().iterator();
        if (stepExecutionIter.hasNext()) {
            StepExecution step = (StepExecution)stepExecutionIter.next();
            Date startDate = step.getStartTime();
            startTime = startDate.getTime();
        }
        log.info("[JOB] END jobId:{},sendId:{},schdId:{},jobState:{}, isLocked:{}, END [{}] seconds", new Object[]{jobExecution.getId(), sendId, schdId, jobExecution.getStatus(), this.lockController.isLocked(), (double)(endTime - startTime) / 1000.0});
    }

    public void beforeJob(JobExecution jobExecution) {
        long sendId = jobExecution.getJobParameters().getLong("sendId");
        long schdId = jobExecution.getJobParameters().getLong("schdId");
        String lockKey = jobExecution.getJobParameters().getString("lockKey");
        for (StepExecution step : jobExecution.getStepExecutions()) {
            step.setStartTime(new Date());
        }
        this.lockController = this.contexter.lock(lockKey);
        this.lockController.lock();
        log.info("[JOB] START jobId:{},sendId:{},schdId:{},isLocked:{} START", new Object[]{jobExecution.getId(), sendId, schdId, lockKey, this.lockController.isLocked()});
    }
}

