/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.listener;

import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanRdbJobListener
extends JobExecutionListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(CleanRdbJobListener.class);
    @Autowired
    private LockContexter contexter;
    private LockController lockController = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterJob(JobExecution jobExecution) {
        if (jobExecution.getStatus() == BatchStatus.COMPLETED) {
            // empty if block
        }
        try {
            long startTime = jobExecution.getJobParameters().getLong("time");
            log.info("[JOB] END job id {} state {} END [{}] seconds", new Object[]{jobExecution.getId(), jobExecution.getStatus(), System.currentTimeMillis() - startTime});
            if (this.lockController == null) {
                this.lockController = this.contexter.lock("lock.manager.clean.rdb");
            }
            if (this.lockController.isLocked()) {
                this.lockController.unLock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void beforeJob(JobExecution jobExecution) {
        this.lockController = this.contexter.lock("lock.manager.clean.rdb");
        this.lockController.lock();
        log.info("[JOB] START job id {} START", (Object)jobExecution.getId());
    }
}

