/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch.executor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.manager.batch.listener.StatJobListener;
import com.humuson.tms.manager.repository.model.SchdInfoModel;
import com.humuson.tms.manager.stat.Stat;
import com.humuson.tms.util.date.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
@EnableBatchProcessing
@Scope(value="prototype")
@Qualifier(value="statInfoBatchExecutor")
public class StatInfoBatchExecutor {
    private static final Logger log = LoggerFactory.getLogger(StatInfoBatchExecutor.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    @Qualifier(value="StatJobListener")
    StatJobListener statJobListener;
    @Autowired
    @Qualifier(value="asyncJobLauncher")
    JobLauncher asyncJobLauncher;
    @Autowired
    Stat statService;

    public int executor(SchdInfoModel sim) {
        long schdId = sim.getSchdId();
        long sendId = sim.getSendId();
        String lockKey = "lock.manager.result.stat.info.schd." + schdId;
        long time = Long.parseLong(DateUtil.getFullDate((String)"yyyyMMddHH24mm"));
        String jobName = "statJob." + schdId + "." + time;
        try {
            JobParameters jobParameters = new JobParametersBuilder().addString("jobName", jobName).addString("lockKey", lockKey).addLong("time", Long.valueOf(time)).addLong("schdId", Long.valueOf(schdId)).addLong("sendId", Long.valueOf(sendId)).addString("workday", sim.getWorkday()).addString("triggerMethod", sim.getTriggerMethod()).addString("channelType", sim.getChannelType()).toJobParameters();
            Job job = ((SimpleJobBuilder)((JobBuilder)this.jobBuilderFactory.get(jobName).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(this.statService.step1()).listener((JobExecutionListener)this.statJobListener)).build();
            if (this.wrapperRedisTemplate.hasKey(lockKey)) {
                log.info("is locked : true. sendId:{}, schdId:{}, key :{}", new Object[]{sendId, schdId, lockKey});
                return 0;
            }
            log.info("start batchjob. sendId:{}, schdId:{}, lockkey :{}", new Object[]{sendId, schdId, lockKey});
            this.asyncJobLauncher.run(job, jobParameters);
            return 1;
        }
        catch (BeansException e) {
            log.debug("BeansException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobExecutionAlreadyRunningException e) {
            log.debug("JobExecutionAlreadyRunningException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobRestartException e) {
            log.debug("JobRestartException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobInstanceAlreadyCompleteException e) {
            log.debug("JobInstanceAlreadyCompleteException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (JobParametersInvalidException e) {
            log.debug("StatOnceScheduler jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (DuplicateKeyException e) {
            log.debug("DuplicateKeyException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (IllegalStateException e) {
            log.debug("IllegalStateException jobName:{}, Error : {}", (Object)jobName, (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("sendId:{}, schdId:{}, jobName:{}, Error : {}", new Object[]{sendId, schdId, jobName, e});
        }
        return 0;
    }
}

