/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.manager.batch;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Configuration
@Component
@EnableAsync
public class JobService {
    private static final Logger log = LoggerFactory.getLogger(JobService.class);
    @Autowired
    @Qualifier(value="tmsJobRepository")
    JobRepository jobRepository;
    @Value(value="${tms.manager.thread.async.core-pool:30}")
    private int corePoolSize;
    @Value(value="${tms.manager.thread.async.max-pool:50}")
    private int maxPoolSize;
    @Value(value="${tms.manager.thread.async.capacity:80}")
    private int queueCapacity;
    @Value(value="${tms.manager.thread.async.timeout:180}")
    private int threadTimeout;
    @Autowired
    @Qualifier(value="mnAsyncJobExecutor")
    ThreadPoolTaskExecutor asyncJobExecutor;

    @Bean(value={"syncJobLauncher"})
    public JobLauncher syncJobLauncher() {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        try {
            jobLauncher.setJobRepository(this.jobRepository);
            jobLauncher.afterPropertiesSet();
            log.info("[JobService] syncJobLauncher bean set");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobLauncher;
    }

    @Bean(value={"asyncJobLauncher"})
    public JobLauncher asyncJobLauncher() {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.jobRepository);
        jobLauncher.setTaskExecutor((TaskExecutor)this.asyncJobExecutor);
        try {
            jobLauncher.afterPropertiesSet();
            log.info("[JobService] asyncJobLauncher bean set");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jobLauncher;
    }

    @Bean(value={"mnAsyncJobExecutor"})
    public ThreadPoolTaskExecutor threadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        threadPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        threadPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        threadPoolTaskExecutor.setKeepAliveSeconds(this.threadTimeout);
        threadPoolTaskExecutor.setThreadNamePrefix("mnAsyncJob-");
        log.info("[JobService] mnAsyncJobExecutor bean set");
        return threadPoolTaskExecutor;
    }
}

