/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

@Component
public class LoadAdditionalProperties
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(LoadAdditionalProperties.class);
    private ResourceLoader loader = new DefaultResourceLoader();

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        try {
            Resource resource = this.loader.getResource("classpath:/error/error-code-em.yml");
            if (!resource.exists()) {
                throw new IllegalArgumentException("Resource " + resource + " does not exist");
            }
            log.info("custom resource {}", (Object)resource.getFilename());
            PropertySource propertySource = new PropertySourcesLoader().load(resource);
            event.getEnvironment().getPropertySources().addLast(propertySource);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

