/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.service.impl;

import com.humuson.tms.config.Column;
import com.humuson.tms.util.FileUtil;
import com.humuson.tms.watcher.model.ContentInfoModel;
import com.humuson.tms.watcher.model.InAppMsgModel;
import com.humuson.tms.watcher.model.MapperRequestModel;
import com.humuson.tms.watcher.service.CreateMapperRequestService;
import com.humuson.tms.watcher.util.WatcherUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class CreateMapperRequestServiceImpl
implements CreateMapperRequestService {
    private Logger log = LoggerFactory.getLogger((String)"autoApiTraceLog");
    @Autowired
    @Qualifier(value="tmsRestTemplate")
    RestTemplate restTemplate;

    @Override
    public MapperRequestModel.MapperRequestModelBuilder getContentData(MapperRequestModel.MapperRequestModelBuilder builder, ContentInfoModel params) {
        try {
            String readContent = "";
            try {
                if (!StringUtils.isEmpty((Object)params.getCONTENT_URL())) {
                    readContent = FileUtil.readUrl((String)params.getCONTENT_URL());
                    if (!StringUtils.isEmpty((Object)readContent)) {
                        builder.content(readContent);
                    } else {
                        this.log.info("Read CONTENT_URL is null ==> contentUrl:{} / readContent: {}", (Object)params.getCONTENT_URL(), (Object)readContent);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.info("Read CONTENT_URL has Exception. will Read content by contentPath. e: {}", (Throwable)e);
            }
            try {
                if (!StringUtils.isEmpty((Object)params.getCONTENT_PATH()) && StringUtils.isEmpty((Object)readContent)) {
                    readContent = FileUtil.readLocal((String)params.getCONTENT_PATH(), (String)"UTF-8");
                    if (!StringUtils.isEmpty((Object)readContent)) {
                        builder.content(readContent);
                    } else {
                        this.log.info("Read CONTENT_PATH is null ==> contentPath:{} / readContent: {}", (Object)params.getCONTENT_PATH(), (Object)readContent);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.info("Read CONTENT_PATH has Exception. e: {}", (Throwable)e);
            }
            this.log.info("Read readContent.length :{}, url : {}, path:{}", new Object[]{readContent.length(), params.getCONTENT_URL(), params.getCONTENT_PATH()});
            builder.contentpath(params.getCONTENT_PATH());
            builder.contentUrl(params.getCONTENT_URL());
            builder.switchFlag(params.getSWITCH_FLAG());
            builder.subject(params.getSUBJECT());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder;
    }

    @Override
    public MapperRequestModel.MapperRequestModelBuilder getMappingData(MapperRequestModel.MapperRequestModelBuilder builder, Map<String, Object> params) throws FileNotFoundException, IOException {
        String mapping = null;
        if (!StringUtils.isEmpty((Object)((String)params.get(Column.EVENT_INFO1)))) {
            mapping = ((String)params.get(Column.EVENT_INFO1)).equals("Y") ? WatcherUtil.fileRead((String)params.get(Column.EVENT_INFO3)) : (String)params.get(Column.CONTENT_DATA);
            builder.mapping(mapping);
        }
        return builder;
    }

    @Override
    public MapperRequestModel.MapperRequestModelBuilder getTargetData(MapperRequestModel.MapperRequestModelBuilder builder, Map<String, Object> params) {
        builder.type((String)params.get(Column.TYPE));
        builder.channelType((String)params.get(Column.CHANNEL_TYPE));
        builder.memberId((String)params.get(Column.TMS_M_ID));
        builder.targetName((String)params.get(Column.TMS_M_NAME));
        builder.targetEmail((String)params.get(Column.TMS_M_EMAIL));
        builder.targetPhone((String)params.get(Column.TMS_M_PHONE));
        builder.sendId(String.valueOf(params.get(Column.SEND_ID)));
        return builder;
    }

    @Override
    public MapperRequestModel.MapperRequestModelBuilder getContentData(MapperRequestModel.MapperRequestModelBuilder builder, InAppMsgModel inAppData) {
        builder.pushMsg(inAppData.getPUSH_MSG());
        builder.subject(inAppData.getPUSH_TITLE());
        builder.pushType(inAppData.getPUSH_TYPE());
        builder.inappMsg(inAppData.getINAPP_MSG());
        builder.content(inAppData.getINAPP_MSG());
        builder.pushImg(inAppData.getPUSH_IMG());
        builder.pushValue(inAppData.getPUSH_VALUE());
        return builder;
    }

    @Override
    public MapperRequestModel.MapperRequestModelBuilder getPushContentData(MapperRequestModel.MapperRequestModelBuilder builder, ContentInfoModel params) throws IOException {
        builder.pushMsg(params.getPUSH_MSG());
        builder.subject(params.getSUBJECT());
        builder.pushType(params.getPUSH_TYPE());
        String readContent = "";
        if (!StringUtils.isEmpty((Object)params.getCONTENT_URL())) {
            readContent = FileUtil.readUrl((String)params.getCONTENT_URL());
            if (!StringUtils.isEmpty((Object)readContent)) {
                builder.content(readContent);
            } else {
                this.log.info("Read CONTENT_URL is null ==> contentUrl:{} / readContent: {}", (Object)params.getCONTENT_URL(), (Object)readContent);
            }
        }
        if (!StringUtils.isEmpty((Object)params.getCONTENT_PATH()) && StringUtils.isEmpty((Object)readContent)) {
            readContent = FileUtil.readLocal((String)params.getCONTENT_PATH(), (String)"UTF-8");
            if (!StringUtils.isEmpty((Object)readContent)) {
                builder.content(readContent);
            } else {
                this.log.info("Read CONTENT_PATH is null ==> contentPath:{} / readContent: {}", (Object)params.getCONTENT_PATH(), (Object)readContent);
            }
        }
        builder.pushImg(params.getPUSH_IMG());
        builder.pushValue(params.getPUSH_VALUE());
        return builder;
    }
}

