/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.scheduler;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.util.date.DateUtil;
import com.humuson.tms.watcher.monitor.ActiveMqChecker;
import com.humuson.tms.watcher.monitor.DbChecker;
import com.humuson.tms.watcher.monitor.HddChecker;
import com.humuson.tms.watcher.monitor.RedisChecker;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class CheckLiveScheduler {
    private static final Logger log = LoggerFactory.getLogger(CheckLiveScheduler.class);
    @Autowired
    HddChecker hddChecker;
    @Autowired
    RedisChecker redisChecker;
    @Autowired
    ActiveMqChecker activeMqChecker;
    @Autowired
    DbChecker dbChecker;
    @Value(value="${tms.daemon-type}")
    private String daemonType;
    @Value(value="${tms.daemon-id}")
    private String daemonId;
    @Value(value="${tms.watcher.memory-check.max-percent:80}")
    private int memoryMaxPercent;
    @Autowired
    private WrapperRedisTemplate wrapperRedisTemplate;
    private Logger liveTraceLogger = LoggerFactory.getLogger((String)"liveTraceLog");

    @Scheduled(fixedDelayString="${tms.watcher.check-interval:30000}")
    private void schedule() {
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memUsage = memoryMxBean.getHeapMemoryUsage();
        DecimalFormat df = new DecimalFormat("#0");
        String smemUsed = df.format((double)memUsage.getUsed() / 1048576.0);
        String smemMax = df.format((double)memUsage.getMax() / 1048576.0);
        String[] dates = DateUtil.getDivideDateDefault();
        String key = "JSTAT:" + this.daemonType;
        String field = this.daemonId + ":" + dates[0];
        this.liveTraceLogger.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{key, field, dates[1], smemMax, smemUsed});
        log.info("Redis::[CheckLive] KEY:{}, FIELD:{}, DATA:{} / max {} MB used {} MB", new Object[]{key, field, dates[1], smemMax, smemUsed});
        try {
            String oldValue = this.wrapperRedisTemplate.hmget(key, field);
            oldValue = oldValue == null || oldValue.trim().isEmpty() ? "" : oldValue + "|";
            this.wrapperRedisTemplate.hmset(key, field, oldValue + dates[1] + ":" + smemMax + ":" + smemUsed);
        }
        catch (Exception e) {
            this.liveTraceLogger.error("{}|||Redis::[CheckLive] KEY:{}, FIELD:{}, ERROR:{}", new Object[]{"CM0201", key, field, e});
        }
        this.isCheckMemory(smemMax, smemUsed);
        this.allCheck();
    }

    public boolean isCheckMemory(String totalMemory, String useMemory) {
        boolean res = false;
        int usePercent = (int)(Double.parseDouble(useMemory) / Double.parseDouble(totalMemory) * 100.0);
        log.info("[HeapMemory] useMemory:{}/totalMemory:{}, using:{}%/criticalPercent:{}% ", new Object[]{totalMemory, useMemory, usePercent, this.memoryMaxPercent});
        if (usePercent >= this.memoryMaxPercent) {
            res = true;
        }
        return res;
    }

    public boolean allCheck() {
        List jmxList;
        ArrayList<Object> arrStatus = this.hddChecker.getStatus();
        if (arrStatus != null && arrStatus.size() > 1) {
            log.info("[HDD] Free:{}GB/TOTAL:{}GB, using:{}%/threshold:{}%", new Object[]{arrStatus.get(1), arrStatus.get(2), 100.0 - (Double)arrStatus.get(3), arrStatus.get(4)});
        }
        if ((arrStatus = this.redisChecker.getStatus()) != null && arrStatus.size() > 1) {
            log.info("[REDIS] used:{}MB/TOTAL:{}MB, using:{}%/threshold:{}%", new Object[]{arrStatus.get(1), arrStatus.get(2), arrStatus.get(3), arrStatus.get(4)});
        }
        if ((arrStatus = this.activeMqChecker.getStatus()) != null && arrStatus.size() > 1 && (jmxList = (List)arrStatus.get(1)) != null && jmxList.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[MQ]");
            for (Map jmxMap : jmxList) {
                if (!jmxMap.containsKey("broker")) continue;
                buffer.append(" broker: " + ((String)jmxMap.get("broker")).trim());
                if (jmxMap.containsKey("memoryUsage")) {
                    buffer.append(" using:" + ((String)jmxMap.get("memoryUsage")).trim() + "%");
                }
                if (jmxMap.containsKey("threshold")) {
                    buffer.append("/threshold:" + ((String)jmxMap.get("threshold")).trim() + "%");
                }
                buffer.append(",");
            }
            String resultLog = buffer.toString();
            resultLog.substring(0, resultLog.length() - 1);
            log.info(resultLog);
        }
        return true;
    }
}

