/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.monitor;

import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;

public abstract class ThresholdChecker {
    private static final Logger log = LoggerFactory.getLogger(ThresholdChecker.class);
    @Value(value="${tms.watcher.path.hdd}")
    public String hddPath;
    private String db_path = ".";
    @Value(value="${tms.watcher.threshold.db:80}")
    public int thresholdPer_db;
    @Value(value="${tms.watcher.threshold.hdd:80}")
    public int thresholdPer_hdd;
    @Value(value="${tms.watcher.threshold.memory:80}")
    public int thresholdPer_memory;
    @Value(value="${tms.watcher.threshold.redis:80}")
    public int thresholdPer_redis;
    @Value(value="${tms.watcher.threshold.mq:80}")
    public int thresholdPer_mq;

    public File checkPath(File path) {
        Assert.isTrue((boolean)path.exists(), (String)("Path '" + path + "' does not exist"));
        Assert.isTrue((boolean)path.canRead(), (String)("Path '" + path + "' cannot be read"));
        return path;
    }

    public double getPercent(long total, long target) {
        return Math.round((double)target / (double)total * 100.0);
    }

    public double getPercent(double total, double target) {
        return Math.round(target / total * 100.0);
    }

    public abstract ArrayList<Object> getStatus();
}

