/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.monitor;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.watcher.monitor.ThresholdChecker;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedisChecker
extends ThresholdChecker {
    private static final Logger log = LoggerFactory.getLogger(RedisChecker.class);
    @Autowired
    WrapperRedisTemplate wrapperRedisTemplate;
    final String MG_KEY_SYS = "total_system_memory";
    final String MG_KEY_MAX = "maxmemory";
    final String MG_KEY_USED = "used_memory";

    public boolean returnUseable() {
        return this.processThresholdMg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Object> getStatus() {
        ArrayList<Object> arrStatus = new ArrayList<Object>();
        boolean checkResult = true;
        arrStatus.add(checkResult);
        Properties prop = null;
        try {
            prop = this.wrapperRedisTemplate.info();
            if (prop != null) {
                double result;
                double systemMemory = Double.parseDouble(prop.getProperty("total_system_memory", "0")) / 1048576.0;
                double maxMemory = Double.parseDouble(prop.getProperty("maxmemory", "0")) / 1048576.0;
                double usedMemory = Double.parseDouble(prop.getProperty("used_memory", "0")) / 1048576.0;
                double targetMemory = maxMemory;
                if (targetMemory == 0.0) {
                    targetMemory = systemMemory;
                }
                checkResult = !((result = usedMemory / targetMemory * 100.0) >= (double)this.thresholdPer_redis);
                arrStatus.set(0, checkResult);
                arrStatus.add(String.format("%.2f", usedMemory));
                arrStatus.add(String.format("%.2f", maxMemory));
                arrStatus.add(String.format("%.2f", result));
                arrStatus.add(this.thresholdPer_redis);
            } else {
                checkResult = false;
            }
        }
        catch (Exception e) {
            checkResult = false;
        }
        finally {
            prop = null;
        }
        return arrStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processThresholdMg() {
        boolean checkResult = true;
        Properties prop = null;
        try {
            prop = this.wrapperRedisTemplate.info();
            if (prop != null) {
                double result;
                double systemMemory = Double.parseDouble(prop.getProperty("total_system_memory", "0")) / 1048576.0;
                double maxMemory = Double.parseDouble(prop.getProperty("maxmemory", "0")) / 1048576.0;
                double usedMemory = Double.parseDouble(prop.getProperty("used_memory", "0")) / 1048576.0;
                double targetMemory = maxMemory;
                if (targetMemory == 0.0) {
                    targetMemory = systemMemory;
                }
                if ((result = usedMemory / targetMemory * 100.0) >= (double)this.thresholdPer_redis) {
                    log.error("[CheckRedis] WARNING!! max {} target {} used {} percent {}", new Object[]{maxMemory, targetMemory, usedMemory, result});
                    checkResult = false;
                } else {
                    checkResult = true;
                }
            } else {
                checkResult = false;
            }
        }
        catch (Exception e) {
            checkResult = false;
        }
        finally {
            prop = null;
        }
        return checkResult;
    }
}

