/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.monitor;

import com.humuson.tms.watcher.monitor.ThresholdChecker;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HddChecker
extends ThresholdChecker {
    private static final Logger log = LoggerFactory.getLogger(HddChecker.class);

    public boolean returnFileUseable() {
        boolean result;
        File filepath = this.checkPath(new File(this.hddPath));
        double diskUseInBytes = filepath.getFreeSpace() / 0x40000000L;
        double diskTotalInBytes = filepath.getTotalSpace() / 0x40000000L;
        double usedPercent = this.getPercent(diskTotalInBytes, diskUseInBytes);
        boolean bl = result = 100.0 - usedPercent < (double)this.thresholdPer_hdd;
        if (!result) {
            log.info("[CheckDisk] WARNING!! file useable check : Free {}(GB) / TOTAL {}(GB) - percent {} - threshold percent {}", new Object[]{diskUseInBytes, diskTotalInBytes, 100.0 - usedPercent, this.thresholdPer_hdd});
        }
        return result;
    }

    @Override
    public ArrayList<Object> getStatus() {
        File filepath = this.checkPath(new File(this.hddPath));
        long diskUseInBytes = filepath.getFreeSpace() / 0x40000000L;
        long diskTotalInBytes = filepath.getTotalSpace() / 0x40000000L;
        double usedPercent = this.getPercent(diskTotalInBytes, diskUseInBytes);
        boolean result = 100.0 - usedPercent < (double)this.thresholdPer_hdd;
        ArrayList<Object> arrStatus = new ArrayList<Object>();
        arrStatus.add(result);
        arrStatus.add(diskUseInBytes);
        arrStatus.add(diskTotalInBytes);
        arrStatus.add(usedPercent);
        arrStatus.add(this.thresholdPer_hdd);
        return arrStatus;
    }

    public static long GetFreeHDDSpace(String path) {
        long freeSpace = 0L;
        try {
            freeSpace = new File(path).getFreeSpace() / 0x100000L;
        }
        catch (Exception e) {
            log.error("hdd free space error", (Throwable)e);
        }
        return freeSpace;
    }

    public static long GetMaxHddSpace(String path) {
        long freeSpace = 0L;
        try {
            freeSpace = new File(path).getTotalSpace() / 0x100000L;
        }
        catch (Exception e) {
            log.error("hdd max space error", (Throwable)e);
        }
        return freeSpace;
    }
}

