/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.watcher.monitor;

import com.humuson.tms.watcher.monitor.ThresholdChecker;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DbChecker
extends ThresholdChecker {
    private static final Logger log = LoggerFactory.getLogger(DbChecker.class);
    @Value(value="${tms.daemon-type}")
    private String oracleTableSpace;
    private static final String DEFAULT_QUERY = "SELECT 1";
    private static final String ORACLE_DEFAULT_QUERY = "SELECT USE.TABLESPACE_NAME,\r\n      (USE.U_BYTES + FREE.F_BYTES) AS \"total_GB\",\r\n       USE.U_BYTES   AS \"used_GB\", USE.U_BLOCKS  AS \"used_BLOCKS\",\r\n       FREE.F_BYTES  AS \"free_GB\", FREE.F_BLOCKS AS \"free_BLOCKS\"\r\nFROM\r\n    ( SELECT TABLESPACE_NAME, SUM(bytes)/1024/1024/1024 AS U_BYTES,  SUM(blocks) AS U_BLOCKS\r\n      FROM   USER_TS_QUOTAS  GROUP BY TABLESPACE_NAME) USE,\r\n    ( SELECT TABLESPACE_NAME, SUM(bytes)/1024/1024/1024 AS F_BYTES, SUM(blocks) AS F_BLOCKS\r\n      FROM   USER_FREE_SPACE GROUP BY TABLESPACE_NAME) FREE\r\nWHERE USE.TABLESPACE_NAME = FREE.TABLESPACE_NAME and USE.TABLESPACE_NAME='TS_LST_DAT';";
    private static final String MYSQL_DEFAULT_QUERY = "SELECT SUM(data_length+index_length)/1024/1024/1024 used_GB, SUM(data_free)/1024/1024/1024 free_GB FROM information_schema.tables";
    private static final String MSSQL_DEFAULT_QUERY = "SELECT 1";

    @Override
    public ArrayList<Object> getStatus() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetDBSpace(String DB, String url, String id, String pw) {
        long rtn = 0L;
        Connection con = null;
        Statement cstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = DriverManager.getConnection(url, id, pw);
            if (DB.equalsIgnoreCase("mssql")) {
                cstmt = con.prepareCall("{call sp_spaceused}");
                rs = cstmt.executeQuery();
                if (rs.next()) {
                    rtn = (int)Float.parseFloat(rs.getString(2).replaceAll("MB", "").replaceAll(" ", "").replaceAll(",", ""));
                }
            } else if (DB.equalsIgnoreCase("oracle")) {
                rtn = DbChecker.GetOracleDBSize(con);
            } else if (DB.equalsIgnoreCase("mysql") || DB.equalsIgnoreCase("maria")) {
                stmt = con.createStatement();
                rs = stmt.executeQuery(MYSQL_DEFAULT_QUERY);
                while (rs.next()) {
                    rtn += rs.getLong("used_GB") + rs.getLong("free_GB");
                }
                rtn = rtn / 1024L / 1024L;
            }
        }
        catch (Exception e) {
            log.error("DB space error", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long GetOracleDBSize(Connection con) {
        if (con == null) {
            return 0L;
        }
        long rtn = 0L;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select sum(bytes) from user_free_space");
            while (rs.next()) {
                rtn += rs.getLong(1);
            }
            rtn = rtn / 1024L / 1024L;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return rtn;
    }
}

